/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiYieldStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import org.jetbrains.annotations.NotNull;

public final class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), (int)1, (int)10000)});
        if (optPane == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer intDensity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
        if (string == null) {
            SwitchStatementDensityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementDensityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SwitchStatementDensityVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementDensityVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(0);
            }
            this.checkSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(1);
            }
            this.checkSwitchBlock((PsiSwitchBlock)expression);
        }

        private void checkSwitchBlock(PsiSwitchBlock block) {
            PsiCodeBlock body = block.getBody();
            if (body == null) {
                return;
            }
            int branchCount = Math.abs(SwitchUtils.calculateBranchCount(block));
            if (branchCount == 0) {
                return;
            }
            double density = SwitchStatementDensityVisitor.calculateDensity(body, branchCount);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerError(block.getFirstChild(), intDensity);
        }

        private static double calculateDensity(@NotNull PsiCodeBlock body, int branchCount) {
            if (body == null) {
                SwitchStatementDensityVisitor.$$$reportNull$$$0(2);
            }
            StatementCountVisitor visitor2 = new StatementCountVisitor();
            body.accept((PsiElementVisitor)visitor2);
            return (double)branchCount / (double)visitor2.getStatementCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementDensityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateDensity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int statementCount;

        private StatementCountVisitor() {
        }

        public void visitStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                StatementCountVisitor.$$$reportNull$$$0(0);
            }
            super.visitStatement(statement);
            if (statement instanceof PsiSwitchLabelStatementBase || statement instanceof PsiBreakStatement || statement instanceof PsiYieldStatement) {
                return;
            }
            ++this.statementCount;
        }

        int getStatementCount() {
            return this.statementCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$StatementCountVisitor", "visitStatement"));
        }
    }
}

