/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryBreakInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.break.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryBreakInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("break");
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBreakVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryBreakInspection", "buildErrorString"));
    }

    private static class UnnecessaryBreakVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBreakVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                UnnecessaryBreakVisitor.$$$reportNull$$$0(0);
            }
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (exitedStatement instanceof PsiSwitchBlock ? !SwitchUtils.isRuleFormatSwitch((PsiSwitchBlock)exitedStatement) || statement.getLabelIdentifier() != null : statement.getLabelIdentifier() == null) {
                return;
            }
            if (exitedStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)exitedStatement;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)statement)) {
                    this.registerError(statement.getFirstChild(), new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement((PsiElement)exitedStatement, (PsiStatement)statement)) {
                this.registerError(statement.getFirstChild(), new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryBreakInspection$UnnecessaryBreakVisitor", "visitBreakStatement"));
        }
    }
}

