/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryContinueInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryContinueInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInThenBranch", (String)InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryContinueInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryContinueVisitor();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            UnnecessaryContinueInspection.$$$reportNull$$$0(2);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("continue");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/UnnecessaryContinueInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/UnnecessaryContinueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class UnnecessaryContinueVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryContinueVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                UnnecessaryContinueVisitor.$$$reportNull$$$0(0);
            }
            PsiStatement continuedStatement = statement.findContinuedStatement();
            PsiStatement body = null;
            if (continuedStatement instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)continuedStatement;
                body = loopStatement.getBody();
            }
            if (body == null) {
                return;
            }
            if (UnnecessaryContinueInspection.this.ignoreInThenBranch && UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock((PsiElement)statement, (PsiElement)continuedStatement)) {
                return;
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)statement)) {
                    this.registerError(statement.getFirstChild(), new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement((PsiElement)body, (PsiStatement)statement)) {
                this.registerError(statement.getFirstChild(), new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/UnnecessaryContinueInspection$UnnecessaryContinueVisitor", "visitContinueStatement"));
        }
    }
}

