/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantValueVariableUseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantValueVariableUseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression.getText());
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection", "buildErrorString"));
    }

    private static class ReplaceReferenceWithExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
            if (string == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceReferenceWithExpressionFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression, this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getThenBranch();
            this.checkCondition(condition, body);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.checkLoop((PsiConditionalLoopStatement)statement);
        }

        private void checkLoop(PsiConditionalLoopStatement loop) {
            PsiExpression condition = loop.getCondition();
            PsiStatement body = loop.getBody();
            this.checkCondition(condition, body);
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @Nullable PsiStatement body) {
            if (body == null) {
                return false;
            }
            if (!(condition instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand, body)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length != 2) {
                return false;
            }
            PsiExpression lhs = operands[0];
            PsiExpression rhs = operands[1];
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression, @NotNull PsiExpression constantExpression, @NotNull PsiElement body) {
            PsiType constantType;
            if (constantExpression == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(3);
            }
            if (body == null) {
                ConstantValueVariableUseVisitor.$$$reportNull$$$0(4);
            }
            if ((constantType = constantExpression.getType()) == null) {
                return false;
            }
            if (PsiTypes.doubleType().equals((Object)constantType)) {
                Object result = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result) || Double.valueOf(-0.0).equals(result)) {
                    return false;
                }
            }
            if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (target instanceof PsiField) {
                return false;
            }
            VariableReadVisitor visitor2 = new VariableReadVisitor(variable);
            body.accept((PsiElementVisitor)visitor2);
            if (!visitor2.isRead()) {
                return false;
            }
            PsiReferenceExpression reference = visitor2.getReference();
            PsiType referenceType = reference.getType();
            if (referenceType == null) {
                return false;
            }
            if (!referenceType.isAssignableFrom(constantType)) {
                return false;
            }
            this.registerError((PsiElement)reference, constantExpression);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constantExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConstantValueVariableUse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read;
        private boolean stop;
        private PsiReferenceExpression reference;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                VariableReadVisitor.$$$reportNull$$$0(0);
            }
            this.read = false;
            this.stop = false;
            this.reference = null;
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableReadVisitor.$$$reportNull$$$0(1);
            }
            if (this.read || this.stop) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                VariableReadVisitor.$$$reportNull$$$0(2);
            }
            if (this.read || this.stop) {
                return;
            }
            PsiElement target = expression.resolve();
            if (this.variable.equals((Object)target)) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                    this.stop = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading((PsiExpression)expression)) {
                    if (VariableReadVisitor.isInLoopCondition((PsiExpression)expression)) {
                        this.stop = true;
                    } else {
                        this.reference = expression;
                        this.read = true;
                    }
                    return;
                }
            }
            super.visitReferenceExpression(expression);
        }

        private static boolean isInLoopCondition(PsiExpression expression) {
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            return statement instanceof PsiLoopStatement;
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

