/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassWithTooManyDependenciesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(3);
        }
        if (refEntity instanceof RefClass) {
            RefClass refClass = (RefClass)refEntity;
            if (!(refClass.getOwner() instanceof RefPackage)) {
                return null;
            }
            Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
            int numDependencies = dependencies.size();
            if (numDependencies <= this.limit) {
                return null;
            }
            String errorString = InspectionGadgetsBundle.message("class.with.too.many.dependencies.problem.descriptor", refClass.getName(), numDependencies, this.limit);
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        return null;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"limit", (String)InspectionGadgetsBundle.message("class.with.too.many.dependencies.max.option", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

