/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public final class CyclicClassDependencyInspection
extends BaseGlobalInspection {
    public boolean ignoreInSameFile = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInSameFile", (String)InspectionGadgetsBundle.message("cyclic.class.dependency.ignore.in.same.file", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        if (refEntity == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(1);
        }
        if (analysisScope == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(2);
        }
        if (inspectionManager == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(3);
        }
        if (globalInspectionContext == null) {
            CyclicClassDependencyInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        if (refClass.isAnonymous() || refClass.isLocalClass() || refClass.isSyntheticJSP()) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateTransitiveDependenciesForClass(refClass);
        Set<RefClass> dependents = DependencyUtils.calculateTransitiveDependentsForClass(refClass);
        VirtualFile vFile = refClass.getPointer().getVirtualFile();
        if (this.ignoreInSameFile) {
            Predicate<RefClass> filter = aClass -> aClass.getPointer().getVirtualFile().equals(vFile);
            dependencies.removeIf(filter);
            dependents.removeIf(filter);
        }
        HashSet<RefClass> mutualDependents = new HashSet<RefClass>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        if (numMutualDependents == 1) {
            classes = mutualDependents.toArray(new RefClass[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.1.problem.descriptor", refEntity.getName(), classes[0].getExternalName());
        } else if (numMutualDependents == 2) {
            classes = mutualDependents.toArray(new RefClass[2]);
            Arrays.sort(classes, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.2.problem.descriptor", refEntity.getName(), classes[0].getExternalName(), classes[1].getExternalName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.class.dependency.problem.descriptor", refEntity.getName(), numMutualDependents);
        }
        PsiElement anchor = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (anchor == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(anchor, errorString, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/CyclicClassDependencyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/CyclicClassDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

