/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class FinallyBlockCannotCompleteNormallyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "finally";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finally.block.cannot.complete.normally.problem.descriptor", new Object[0]);
        if (string == null) {
            FinallyBlockCannotCompleteNormallyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinallyBlockCannotCompleteNormallyVisitor();
    }

    private static boolean isInMainMethod(@NotNull PsiStatement statement) {
        PsiMethod method;
        if (statement == null) {
            FinallyBlockCannotCompleteNormallyInspection.$$$reportNull$$$0(1);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class)) == null) {
            return false;
        }
        if (!"main".equals(method.getName())) {
            return false;
        }
        PsiModifierList modifierList = method.getModifierList();
        if (!modifierList.hasExplicitModifier("static") || !modifierList.hasExplicitModifier("public") || method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiParameter parameter = parameters[0];
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)parameter.getType(), PsiArrayType.class);
        if (arrayType == null) {
            return false;
        }
        PsiType componentType = arrayType.getDeepComponentType();
        return "java.lang.String".equals(componentType.getCanonicalText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/errorhandling/FinallyBlockCannotCompleteNormallyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/errorhandling/FinallyBlockCannotCompleteNormallyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInMainMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class FinallyBlockCannotCompleteNormallyVisitor
    extends BaseInspectionVisitor {
        private FinallyBlockCannotCompleteNormallyVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiElement[] children;
            if (statement == null) {
                FinallyBlockCannotCompleteNormallyVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            PsiCodeBlock finallyBlock = statement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (FinallyBlockCannotCompleteNormallyInspection.isInMainMethod((PsiStatement)statement)) {
                return;
            }
            if (ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
                return;
            }
            for (PsiElement child : children = statement.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                this.registerError(child, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/FinallyBlockCannotCompleteNormallyInspection$FinallyBlockCannotCompleteNormallyVisitor", "visitTryStatement"));
        }
    }
}

