/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowFromFinallyBlockInspection
extends BaseInspection {
    public boolean warnOnAllExceptions = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"warnOnAllExceptions", (String)InspectionGadgetsBundle.message("throw,from.finally.block.everywhere.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("throw.from.finally.block.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowFromFinallyBlockInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiClassType type = (PsiClassType)infos[0];
        String string = InspectionGadgetsBundle.message("possible.throw.from.finally.block.problem.descriptor", type.getPresentableText());
        if (string == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowFromFinallyBlockVisitor();
    }

    private static PsiCodeBlock getContainingFinallyBlock(@NotNull PsiElement element, @NotNull PsiType thrownType) {
        if (element == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(3);
        }
        if (thrownType == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(4);
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return finallyBlock;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)tryStatement.getTryBlock(), (PsiElement)currentElement, (boolean)true) && ThrowFromFinallyBlockInspection.isCaught(tryStatement, thrownType)) {
                return null;
            }
            currentElement = tryStatement;
        }
        return null;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiType exceptionType) {
        for (PsiParameter parameter : tryStatement.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (!type.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFinallyBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private class ThrowFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ThrowFromFinallyBlockVisitor() {
        }

        public void visitCallExpression(@NotNull PsiCallExpression expression) {
            if (expression == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitCallExpression(expression);
            if (!ThrowFromFinallyBlockInspection.this.warnOnAllExceptions) {
                return;
            }
            List exceptions = ExceptionUtil.getThrownExceptions((PsiElement)expression);
            if (exceptions.isEmpty()) {
                return;
            }
            for (PsiClassType exception : exceptions) {
                PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)expression, (PsiType)exception);
                if (finallyBlock == null || !this.isHidingOfPreviousException(finallyBlock, (PsiElement)expression)) continue;
                if (expression instanceof PsiMethodCallExpression) {
                    this.registerMethodCallError((PsiMethodCallExpression)expression, exception);
                } else if (expression instanceof PsiNewExpression) {
                    this.registerNewExpressionError((PsiNewExpression)expression, exception);
                }
                return;
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if (statement == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(1);
            }
            super.visitThrowStatement(statement);
            PsiExpression exception = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getException());
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type == null) {
                return;
            }
            PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)statement, type);
            if (finallyBlock == null) {
                return;
            }
            if (exception instanceof PsiReferenceExpression && ((target = (referenceExpression = (PsiReferenceExpression)exception).resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)target, (boolean)true))) {
                return;
            }
            if (this.isHidingOfPreviousException(finallyBlock, (PsiElement)statement)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }

        private boolean isHidingOfPreviousException(PsiCodeBlock finallyBlock, PsiElement throwElement) {
            PsiElement parent = finallyBlock.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return false;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length == 0) {
                return true;
            }
            PsiIfStatement ifStatement = this.getParentOfType(throwElement, PsiIfStatement.class, (PsiElement)finallyBlock);
            if (ifStatement == null) {
                return true;
            }
            boolean inThenBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)throwElement, (boolean)false);
            boolean inElseBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)throwElement, (boolean)false);
            if (!inThenBranch && !inElseBranch) {
                return true;
            }
            PsiExpression condition = ifStatement.getCondition();
            PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(condition, inThenBranch);
            if (variable == null) {
                return true;
            }
            boolean assigned = true;
            for (PsiCodeBlock catchBlock : catchBlocks) {
                assigned &= VariableAccessUtils.variableIsAssigned(variable, (PsiElement)catchBlock);
            }
            return !assigned;
        }

        @Nullable
        public <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, @NotNull PsiElement stopAt) {
            if (aClass == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(2);
            }
            if (stopAt == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(3);
            }
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            for (element = element.getParent(); element != null && !aClass.isInstance(element); element = element.getParent()) {
                if (element != stopAt && !(element instanceof PsiFile)) continue;
                return null;
            }
            return (T)element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopAt";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection$ThrowFromFinallyBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThrowStatement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParentOfType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

