/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class FinalizeNotProtectedInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.not.declared.protected.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalizeNotProtectedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredProtectedVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ProtectedFinalizeFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeNotProtectedInspection", "buildErrorString"));
    }

    private static class FinalizeDeclaredProtectedVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredProtectedVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FinalizeDeclaredProtectedVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.isFinalize(method)) {
                return;
            }
            if (method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || aClass.isInterface()) {
                return;
            }
            for (PsiMethod superMethod : method.findSuperMethods()) {
                if (!superMethod.hasModifierProperty("public")) continue;
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/finalization/FinalizeNotProtectedInspection$FinalizeDeclaredProtectedVisitor", "visitMethod"));
        }
    }

    private static class ProtectedFinalizeFix
    extends PsiUpdateModCommandQuickFix {
        private ProtectedFinalizeFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("change.modifier.quickfix", "protected");
            if (string == null) {
                ProtectedFinalizeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodName, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ProtectedFinalizeFix.$$$reportNull$$$0(1);
            }
            if (methodName == null) {
                ProtectedFinalizeFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ProtectedFinalizeFix.$$$reportNull$$$0(3);
            }
            PsiMethod method = (PsiMethod)methodName.getParent();
            Objects.requireNonNull(method).getModifierList().setModifierProperty("protected", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/finalization/FinalizeNotProtectedInspection$ProtectedFinalizeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/finalization/FinalizeNotProtectedInspection$ProtectedFinalizeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

