/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddThisQualifierFix
extends PsiUpdateModCommandQuickFix {
    private AddThisQualifierFix() {
    }

    @Nullable
    public static AddThisQualifierFix buildFix(PsiExpression expressionToQualify, PsiMember memberAccessed) {
        if (!AddThisQualifierFix.isThisQualifierPossible(expressionToQualify, memberAccessed)) {
            return null;
        }
        return new AddThisQualifierFix();
    }

    private static boolean isThisQualifierPossible(PsiExpression memberAccessExpression, @NotNull PsiMember member) {
        if (member == null) {
            AddThisQualifierFix.$$$reportNull$$$0(0);
        }
        if (member.hasModifierProperty("static")) {
            return false;
        }
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)memberAccessExpression);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            return true;
        }
        while ((containingClass = PsiUtil.getContainingClass((PsiElement)containingClass)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
        }
        return containingClass != null && !(containingClass instanceof PsiAnonymousClass);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
        if (string == null) {
            AddThisQualifierFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiReferenceExpression expression;
        if (project == null) {
            AddThisQualifierFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AddThisQualifierFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            AddThisQualifierFix.$$$reportNull$$$0(4);
        }
        if ((expression = (PsiReferenceExpression)element).getQualifierExpression() != null) {
            return;
        }
        PsiExpression thisQualifier = ExpressionUtils.getEffectiveQualifier(expression);
        if (!(thisQualifier instanceof PsiThisExpression)) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        @NonNls String newExpression = commentTracker.text((PsiElement)thisQualifier) + "." + commentTracker.text((PsiElement)expression);
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/AddThisQualifierFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/AddThisQualifierFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isThisQualifierPossible";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

