/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nullable;

public final class DelegatingFixFactory {
    @Nullable
    public static LocalQuickFix createMakeSerializableFix(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClassType type = TypeUtils.getType("java.io.Serializable", (PsiElement)aClass);
        return LocalQuickFix.from((ModCommandAction)QuickFixFactory.getInstance().createExtendsListFix(aClass, type, true));
    }

    @Nullable
    public static LocalQuickFix createMakeCloneableFix(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClassType type = TypeUtils.getType("java.lang.Cloneable", (PsiElement)aClass);
        return LocalQuickFix.from((ModCommandAction)QuickFixFactory.getInstance().createExtendsListFix(aClass, type, true));
    }
}

