/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeleteUnnecessaryStatementFix
extends PsiUpdateModCommandQuickFix {
    private final String name;

    public DeleteUnnecessaryStatementFix(@NonNls String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", this.name);
        if (string == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("delete.unnecessary.statement.fix.family.name", new Object[0]);
        if (string == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement keywordElement, @NotNull ModPsiUpdater updater) {
        PsiStatement statement;
        if (project == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(2);
        }
        if (keywordElement == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            DeleteUnnecessaryStatementFix.$$$reportNull$$$0(4);
        }
        if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)keywordElement, PsiStatement.class)) == null) {
            return;
        }
        DeleteUnnecessaryStatementFix.deleteUnnecessaryStatement(statement);
    }

    public static void deleteUnnecessaryStatement(PsiStatement statement) {
        CommentTracker ct = new CommentTracker();
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiDoWhileStatement || parent instanceof PsiForeachStatement || parent instanceof PsiForStatement) {
            ct.replaceAndRestoreComments((PsiElement)statement, "{}");
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/DeleteUnnecessaryStatementFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/DeleteUnnecessaryStatementFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

