/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualityToSafeEqualsFix
extends PsiUpdateModCommandQuickFix
implements PriorityAction {
    private final boolean myNegated;
    private final PriorityAction.Priority myPriority;

    private EqualityToSafeEqualsFix(boolean negated, @NotNull PriorityAction.Priority priority) {
        if (priority == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(0);
        }
        this.myNegated = negated;
        this.myPriority = priority;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myPriority;
        if (priority == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(1);
        }
        return priority;
    }

    @Nullable
    public static EqualityToSafeEqualsFix buildFix(PsiBinaryExpression expression) {
        Nullability nullability = NullabilityUtil.getExpressionNullability(expression.getLOperand(), true);
        if (nullability == Nullability.NOT_NULL) {
            return null;
        }
        PriorityAction.Priority priority = nullability == Nullability.UNKNOWN ? PriorityAction.Priority.TOP : PriorityAction.Priority.NORMAL;
        return new EqualityToSafeEqualsFix(JavaTokenType.NE.equals(expression.getOperationTokenType()), priority);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myNegated ? InspectionGadgetsBundle.message("inequality.to.safe.not.equals.quickfix", new Object[0]) : InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement comparisonToken, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (project == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(4);
        }
        if (comparisonToken == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(6);
        }
        if (!((parent = comparisonToken.getParent()) instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)parent;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
        if (lhs == null || rhs == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String lhsText = tracker.text((PsiElement)lhs);
        String rhsText = tracker.text((PsiElement)rhs);
        @NonNls StringBuilder newExpression = new StringBuilder();
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.OBJECTS_CLASS, (PsiElement)expression) && ClassUtils.findClass("java.util.Objects", (PsiElement)expression) != null) {
            if (JavaTokenType.NE.equals(expression.getOperationTokenType())) {
                newExpression.append('!');
            }
            newExpression.append("java.util.Objects.equals(").append(lhsText).append(',').append(rhsText).append(')');
        } else {
            newExpression.append(lhsText).append("==null?").append(rhsText).append(expression.getOperationSign().getText()).append(" null:");
            if (JavaTokenType.NE.equals(expression.getOperationTokenType())) {
                newExpression.append('!');
            }
            if (ParenthesesUtils.getPrecedence(lhs) > 1) {
                newExpression.append('(').append(lhsText).append(')');
            } else {
                newExpression.append(lhsText);
            }
            newExpression.append(".equals(").append(rhsText).append(')');
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression.toString(), tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/EqualityToSafeEqualsFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonToken";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/EqualityToSafeEqualsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

