/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.format;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.format.FormatPlaceholder;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormatDecode {
    private static final Pattern fsPattern = Pattern.compile("%(?<posSpec>\\d+\\$)?(?<flags>[-#+ 0,(<]*)(?<width>\\d+)?(?<precision>\\.\\d+)?(?<dateSpec>[tT])?(?<conversion>[a-zA-Z%])");
    private static final Validator ALL_VALIDATOR = new AllValidator();
    private static final int LEFT_JUSTIFY = 1;
    private static final int ALTERNATE = 2;
    private static final int PLUS = 4;
    private static final int LEADING_SPACE = 8;
    private static final int ZERO_PAD = 16;
    private static final int GROUP = 32;
    private static final int PARENTHESES = 64;
    private static final int PREVIOUS = 128;

    private FormatDecode() {
    }

    private static int flag(char c) {
        return switch (c) {
            case '-' -> 1;
            case '#' -> 2;
            case '+' -> 4;
            case ' ' -> 8;
            case '0' -> 16;
            case ',' -> 32;
            case '(' -> 64;
            case '<' -> 128;
            default -> -1;
        };
    }

    private static String flagString(int flags) {
        StringBuilder result = new StringBuilder(8);
        if ((flags & 1) != 0) {
            result.append('-');
        }
        if ((flags & 2) != 0) {
            result.append('#');
        }
        if ((flags & 4) != 0) {
            result.append('+');
        }
        if ((flags & 8) != 0) {
            result.append(' ');
        }
        if ((flags & 0x10) != 0) {
            result.append('0');
        }
        if ((flags & 0x20) != 0) {
            result.append(',');
        }
        if ((flags & 0x40) != 0) {
            result.append('(');
        }
        if ((flags & 0x80) != 0) {
            result.append('<');
        }
        return result.toString();
    }

    private static void checkFlags(int value, int allowedFlags, String specifier) {
        int result = value & ~allowedFlags;
        if (result != 0) {
            String flags = FormatDecode.flagString(result);
            throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.flags.not.allowed", flags, specifier, flags.length()));
        }
    }

    public static Validator[] decodePrefix(String prefix, int argumentCount) {
        return FormatDecode.decode(prefix, argumentCount, true, false);
    }

    public static Validator @NotNull [] decode(String formatString, int argumentCount) {
        return FormatDecode.decode(formatString, argumentCount, false, false);
    }

    public static Validator @NotNull [] decodeNoVerify(String formatString, int argumentCount) {
        return FormatDecode.decode(formatString, argumentCount, false, true);
    }

    private static Validator @NotNull [] decode(String formatString, int argumentCount, boolean isPrefix, boolean noVerify) {
        ArrayList<Validator> parameters = new ArrayList<Validator>();
        Matcher matcher = fsPattern.matcher(formatString);
        boolean previousAllowed = false;
        int implicit = 0;
        int pos = 0;
        int i = 0;
        while (matcher.find(i)) {
            Validator allowed;
            int start = matcher.start();
            if (start != i) {
                FormatDecode.checkText(formatString.substring(i, start));
            }
            i = matcher.end();
            boolean isAllVerifier = false;
            if (noVerify || isPrefix && i == formatString.length()) {
                isAllVerifier = true;
            }
            String specifier = matcher.group();
            String posSpec = matcher.group("posSpec");
            String flags = matcher.group("flags");
            String width = matcher.group("width");
            String precision = matcher.group("precision");
            String dateSpec = matcher.group("dateSpec");
            @NonNls String conversion = matcher.group("conversion");
            int flagBits = 0;
            for (int j = 0; j < flags.length(); ++j) {
                char flag = flags.charAt(j);
                int bit = FormatDecode.flag(flag);
                if (bit == -1) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unexpected.flag", Character.valueOf(flag), specifier));
                }
                if ((flagBits | bit) == flagBits) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.duplicate.flag", Character.valueOf(flag), specifier));
                }
                flagBits |= bit;
            }
            if ("n".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 0, specifier);
                if (!StringUtil.isEmpty((String)width)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.width.not.allowed", width, specifier));
                }
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if ("%".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 1, specifier);
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if (posSpec != null) {
                if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unnecessary.position.specifier", posSpec, specifier));
                }
                String num = posSpec.substring(0, posSpec.length() - 1);
                pos = Integer.parseInt(num) - 1;
                if (pos < 0) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.position.specifier", posSpec, specifier));
                }
                previousAllowed = true;
            } else if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                if (!previousAllowed) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.previous.element.not.found", specifier));
                }
            } else {
                previousAllowed = true;
                pos = implicit++;
            }
            if (isAllVerifier) {
                allowed = new AllValidatorWithRange(TextRange.create((int)matcher.start(), (int)matcher.end()), new Spec(posSpec, flags, width, precision, dateSpec, conversion));
            } else if (dateSpec != null) {
                FormatDecode.checkFlags(flagBits, 129, specifier);
                DateTimeConversionType dateTimeConversionType = FormatDecode.getDateTimeConversionType(conversion.charAt(0));
                if (dateTimeConversionType == DateTimeConversionType.UNKNOWN) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unknown.conversion", dateSpec + conversion));
                }
                FormatDecode.checkNoPrecision(precision, specifier);
                allowed = new DateValidator(specifier, dateTimeConversionType);
            } else {
                switch (conversion.charAt(0)) {
                    case 'B': 
                    case 'H': 
                    case 'b': 
                    case 'h': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        allowed = ALL_VALIDATOR;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        FormatDecode.checkFlags(flagBits, 131, specifier);
                        allowed = (flagBits & 2) != 0 ? new FormattableValidator(specifier) : ALL_VALIDATOR;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new CharValidator(specifier);
                        break;
                    }
                    case 'd': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'X': 
                    case 'o': 
                    case 'x': {
                        FormatDecode.checkFlags(flagBits, -45, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        FormatDecode.checkFlags(flagBits, -97, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        FormatDecode.checkFlags(flagBits, -33, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'f': {
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    default: {
                        throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unknown.conversion", specifier));
                    }
                }
            }
            if (precision != null && precision.length() < 2) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.invalid.precision", specifier));
            }
            if (FormatDecode.isAllBitsSet(flagBits, 12)) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.flag.combination", Character.valueOf(' '), Character.valueOf('+'), specifier));
            }
            if (FormatDecode.isAllBitsSet(flagBits, 17)) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.flag.combination", Character.valueOf('-'), Character.valueOf('0'), specifier));
            }
            if (StringUtil.isEmpty((String)width)) {
                if (FormatDecode.isAllBitsSet(flagBits, 1)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.left.justify.no.width", specifier));
                }
                if (FormatDecode.isAllBitsSet(flagBits, 16)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.zero.padding.no.width", specifier));
                }
            }
            FormatDecode.storeValidator(allowed, pos, parameters, argumentCount);
        }
        if (i < formatString.length()) {
            String endString = formatString.substring(i);
            if (!isPrefix) {
                FormatDecode.checkText(endString);
            } else {
                String suggestedString = endString + "s";
                Matcher endMatcher = fsPattern.matcher(suggestedString);
                if (!endMatcher.find() || endMatcher.end() != suggestedString.length()) {
                    FormatDecode.checkText(endString);
                }
            }
        }
        Validator[] validatorArray = parameters.toArray(new Validator[0]);
        if (validatorArray == null) {
            FormatDecode.$$$reportNull$$$0(0);
        }
        return validatorArray;
    }

    private static DateTimeConversionType getDateTimeConversionType(char conversion) {
        return switch (conversion) {
            case 'H', 'I', 'L', 'M', 'N', 'R', 'S', 'T', 'k', 'l', 'p', 'r' -> DateTimeConversionType.TIME;
            case 'Z', 'z' -> DateTimeConversionType.ZONE;
            case 'Q', 'c', 's' -> DateTimeConversionType.ZONED_DATE_TIME;
            case 'A', 'B', 'C', 'D', 'F', 'Y', 'a', 'b', 'd', 'e', 'h', 'j', 'm', 'y' -> DateTimeConversionType.DATE;
            default -> DateTimeConversionType.UNKNOWN;
        };
    }

    private static void checkNoPrecision(String precision, String specifier) {
        if (!StringUtil.isEmpty((String)precision)) {
            throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.precision.not.allowed", precision, specifier));
        }
    }

    private static boolean isAllBitsSet(int value, int mask) {
        return (value & mask) == mask;
    }

    private static void checkText(String s) {
        if (s.indexOf(37) != -1) {
            throw new IllegalFormatException();
        }
    }

    private static void storeValidator(Validator validator, int pos, ArrayList<Validator> parameters, int argumentCount) {
        if (pos < parameters.size()) {
            Validator existing = parameters.get(pos);
            if (existing == null) {
                parameters.set(pos, validator);
            } else if (existing instanceof MultiValidator) {
                ((MultiValidator)existing).addValidator(validator);
            } else if (existing != validator) {
                MultiValidator multiValidator = new MultiValidator(existing.getSpecifier());
                multiValidator.addValidator(existing);
                multiValidator.addValidator(validator);
                parameters.set(pos, multiValidator);
            }
        } else {
            while (pos > parameters.size() && argumentCount > parameters.size()) {
                parameters.add(null);
            }
            parameters.add(validator);
        }
    }

    public static boolean isSuspiciousFormatCall(PsiMethodCallExpression expression, PsiTypeCastExpression cast) {
        Validator[] validators;
        FormatArgument formatArgument = FormatArgument.extract((PsiCallExpression)expression, Collections.emptyList(), Collections.emptyList());
        if (formatArgument == null) {
            return false;
        }
        String value = formatArgument.calculateValue();
        if (value == null) {
            return false;
        }
        int formatArgumentIndex = formatArgument.getIndex();
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        try {
            validators = FormatDecode.decode(value, arguments.length - formatArgumentIndex);
        }
        catch (IllegalFormatException e) {
            return false;
        }
        if (validators.length == 0) {
            return false;
        }
        int idx = IntStream.range(0, arguments.length).filter(i -> PsiTreeUtil.isAncestor((PsiElement)arguments[i], (PsiElement)cast, (boolean)false)).findFirst().orElse(-1);
        if (idx < formatArgumentIndex) {
            return false;
        }
        Validator validator = validators[idx - formatArgumentIndex];
        PsiTypeElement castType = cast.getCastType();
        return validator.valid(Objects.requireNonNull(castType).getType()) && !validator.valid(Objects.requireNonNull(cast.getOperand()).getType());
    }

    @NotNull
    public static @NotNull List<@NotNull FormatPlaceholder> asPlaceholders(Validator @NotNull [] validators) {
        if (validators == null) {
            FormatDecode.$$$reportNull$$$0(1);
        }
        ArrayList<FormatPlaceholder> result = new ArrayList<FormatPlaceholder>();
        for (int i = 0; i < validators.length; ++i) {
            Collection<Validator> collection;
            Validator metaValidator = validators[i];
            if (metaValidator == null) continue;
            if (metaValidator instanceof MultiValidator) {
                MultiValidator multi = (MultiValidator)metaValidator;
                collection = multi.getValidators();
            } else {
                collection = List.of(metaValidator);
            }
            List<Validator> unpacked = collection;
            for (Validator validator : unpacked) {
                TextRange stringRange = validator.getRange();
                if (stringRange == null) continue;
                record MyPlaceholder(int index, @NotNull TextRange range) implements FormatPlaceholder
                {
                    @NotNull
                    private final TextRange range;

                    MyPlaceholder(int index, @NotNull TextRange range) {
                        if (range == null) {
                            MyPlaceholder.$$$reportNull$$$0(0);
                        }
                    }

                    @Override
                    @NotNull
                    public TextRange range() {
                        TextRange textRange = this.range;
                        if (textRange == null) {
                            MyPlaceholder.$$$reportNull$$$0(1);
                        }
                        return textRange;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "range";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/siyeh/ig/format/FormatDecode$1MyPlaceholder";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/siyeh/ig/format/FormatDecode$1MyPlaceholder";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "range";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "<init>";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                }
                result.add(new MyPlaceholder(i, stringRange));
            }
        }
        ArrayList<FormatPlaceholder> arrayList = result;
        if (arrayList == null) {
            FormatDecode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/format/FormatDecode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/format/FormatDecode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asPlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "asPlaceholders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class IllegalFormatException
    extends RuntimeException {
        public IllegalFormatException(@Nls String message) {
            super(message);
        }

        public IllegalFormatException() {
        }
    }

    public static abstract class Validator {
        private final String mySpecifier;

        @Nullable
        public String getInvalidSpecifier(PsiType type) {
            if (this.valid(type)) {
                return null;
            }
            return this.getSpecifier();
        }

        Validator(String specifier) {
            this.mySpecifier = specifier;
        }

        public abstract boolean valid(PsiType var1);

        public String getSpecifier() {
            return this.mySpecifier;
        }

        @Nullable
        public TextRange getRange() {
            return null;
        }

        @Nullable
        public Spec getSpec() {
            return null;
        }
    }

    private static class AllValidatorWithRange
    extends AllValidator {
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final Spec mySpec;

        AllValidatorWithRange(@NotNull TextRange range, @NotNull Spec spec) {
            if (range == null) {
                AllValidatorWithRange.$$$reportNull$$$0(0);
            }
            if (spec == null) {
                AllValidatorWithRange.$$$reportNull$$$0(1);
            }
            this.myRange = range;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public Spec getSpec() {
            Spec spec = this.mySpec;
            if (spec == null) {
                AllValidatorWithRange.$$$reportNull$$$0(2);
            }
            return spec;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                AllValidatorWithRange.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/FormatDecode$AllValidatorWithRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/FormatDecode$AllValidatorWithRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpec";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public record Spec(@Nullable String posSpec, @Nullable String flags, @Nullable String width, @Nullable String precision, @Nullable String dateSpec, @Nullable String conversion) {
    }

    private static enum DateTimeConversionType {
        UNKNOWN,
        TIME,
        ZONE,
        ZONED_DATE_TIME,
        DATE;

    }

    private static class DateValidator
    extends Validator {
        private final DateTimeConversionType dateTimeConversionType;

        DateValidator(String specifier, DateTimeConversionType dateTimeConversionType) {
            super(specifier);
            this.dateTimeConversionType = dateTimeConversionType;
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiTypes.longType().equals((Object)type) || "java.lang.Long".equals(text) || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Date") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Calendar") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.time.temporal.TemporalAccessor") && this.isValidTemporalAccessor(text);
        }

        private boolean isValidTemporalAccessor(String text) {
            return switch (text) {
                case "java.time.LocalDateTime" -> {
                    if (this.dateTimeConversionType == DateTimeConversionType.TIME || this.dateTimeConversionType == DateTimeConversionType.DATE) {
                        yield true;
                    }
                    yield false;
                }
                case "java.time.LocalDate" -> {
                    if (this.dateTimeConversionType == DateTimeConversionType.DATE) {
                        yield true;
                    }
                    yield false;
                }
                case "java.time.LocalTime" -> {
                    if (this.dateTimeConversionType == DateTimeConversionType.TIME) {
                        yield true;
                    }
                    yield false;
                }
                case "java.time.OffsetTime" -> {
                    if (this.dateTimeConversionType == DateTimeConversionType.TIME || this.dateTimeConversionType == DateTimeConversionType.ZONE) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
    }

    private static class FormattableValidator
    extends Validator {
        FormattableValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            return InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Formattable");
        }
    }

    private static class CharValidator
    extends Validator {
        CharValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            if (PsiTypes.charType().equals((Object)type) || PsiTypes.byteType().equals((Object)type) || PsiTypes.shortType().equals((Object)type) || PsiTypes.intType().equals((Object)type)) {
                return true;
            }
            String text = type.getCanonicalText();
            return "java.lang.Character".equals(text) || "java.lang.Byte".equals(text) || "java.lang.Short".equals(text) || "java.lang.Integer".equals(text);
        }
    }

    private static class IntValidator
    extends Validator {
        IntValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiTypes.intType().equals((Object)type) || "java.lang.Integer".equals(text) || PsiTypes.longType().equals((Object)type) || "java.lang.Long".equals(text) || PsiTypes.shortType().equals((Object)type) || "java.lang.Short".equals(text) || PsiTypes.byteType().equals((Object)type) || "java.lang.Byte".equals(text) || "java.math.BigInteger".equals(text);
        }
    }

    private static class FloatValidator
    extends Validator {
        FloatValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            String text = type.getCanonicalText();
            return PsiTypes.doubleType().equals((Object)type) || "java.lang.Double".equals(text) || PsiTypes.floatType().equals((Object)type) || "java.lang.Float".equals(text) || "java.math.BigDecimal".equals(text);
        }
    }

    public static class MultiValidator
    extends Validator {
        private final Set<Validator> validators = new HashSet<Validator>(3);

        @Override
        @Nullable
        public String getInvalidSpecifier(PsiType type) {
            for (Validator validator : this.validators) {
                if (validator.valid(type)) continue;
                return validator.getInvalidSpecifier(type);
            }
            return null;
        }

        MultiValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type) {
            for (Validator validator : this.validators) {
                if (validator.valid(type)) continue;
                return false;
            }
            return true;
        }

        public Set<Validator> getValidators() {
            return this.validators;
        }

        public void addValidator(Validator validator) {
            this.validators.add(validator);
        }
    }

    public static final class FormatArgument {
        private final int myIndex;
        private final PsiExpression myExpression;

        private FormatArgument(int index, PsiExpression expression) {
            this.myIndex = index;
            this.myExpression = expression;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public PsiExpression getExpression() {
            return this.myExpression;
        }

        @Nullable
        public static FormatArgument extract(@NotNull PsiCallExpression expression, @NotNull List<String> methodNames, @NotNull List<String> classNames) {
            if (expression == null) {
                FormatArgument.$$$reportNull$$$0(0);
            }
            if (methodNames == null) {
                FormatArgument.$$$reportNull$$$0(1);
            }
            if (classNames == null) {
                FormatArgument.$$$reportNull$$$0(2);
            }
            return FormatArgument.extract(expression, methodNames, classNames, false);
        }

        @Nullable
        public static FormatArgument extract(@NotNull PsiCallExpression expression, @NotNull List<String> methodNames, @NotNull List<String> classNames, boolean allowNotConstant) {
            int formatArgumentIndex;
            PsiExpression formatArgument;
            PsiExpressionList argumentList;
            if (expression == null) {
                FormatArgument.$$$reportNull$$$0(3);
            }
            if (methodNames == null) {
                FormatArgument.$$$reportNull$$$0(4);
            }
            if (classNames == null) {
                FormatArgument.$$$reportNull$$$0(5);
            }
            if ((argumentList = expression.getArgumentList()) == null) {
                return null;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (expression instanceof PsiMethodCallExpression && FormatUtils.STRING_FORMATTED.matches((PsiExpression)expression)) {
                formatArgument = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
                formatArgumentIndex = 0;
            } else {
                if (!(expression instanceof PsiMethodCallExpression) || !FormatUtils.isFormatCall((PsiMethodCallExpression)expression, methodNames, classNames)) {
                    return FormatArgument.fromPrintFormatAnnotation(expression);
                }
                formatArgumentIndex = IntStream.range(0, arguments.length).filter(i -> ExpressionUtils.hasStringType(arguments[i])).findFirst().orElse(-1);
                if (formatArgumentIndex < 0) {
                    return null;
                }
                formatArgument = arguments[formatArgumentIndex];
                ++formatArgumentIndex;
            }
            if (!ExpressionUtils.hasStringType(formatArgument) || !allowNotConstant && !PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return null;
            }
            return new FormatArgument(formatArgumentIndex, formatArgument);
        }

        private static FormatArgument fromPrintFormatAnnotation(@NotNull PsiCallExpression call) {
            int formatIndex;
            PsiParameter maybeFormat;
            PsiExpressionList argList;
            if (call == null) {
                FormatArgument.$$$reportNull$$$0(6);
            }
            if ((argList = call.getArgumentList()) == null || argList.isEmpty()) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length < 2) {
                return null;
            }
            PsiType lastParameterType = parameters[parameters.length - 1].getType();
            if (lastParameterType instanceof PsiArrayType && TypeUtils.isJavaLangObject(((PsiArrayType)lastParameterType).getComponentType()) && TypeUtils.isJavaLangString((maybeFormat = parameters[formatIndex = parameters.length - 2]).getType()) && AnnotationUtil.isAnnotated((PsiModifierListOwner)maybeFormat, (String)"org.intellij.lang.annotations.PrintFormat", (int)2)) {
                PsiExpression[] args = argList.getExpressions();
                if (args.length <= formatIndex) {
                    return null;
                }
                return new FormatArgument(formatIndex + 1, args[formatIndex]);
            }
            return null;
        }

        public String calculateValue() {
            PsiType formatType = this.myExpression.getType();
            if (formatType == null) {
                return null;
            }
            return (String)ConstantExpressionUtil.computeCastTo((PsiExpression)this.myExpression, (PsiType)formatType);
        }

        public String calculatePrefixValue() {
            StringBuilder builder = new StringBuilder();
            boolean hasText = false;
            PsiType formatType = this.myExpression.getType();
            if (formatType == null || !formatType.equalsToText("java.lang.String")) {
                return null;
            }
            PsiExpression psiExpression = this.myExpression;
            PsiExpression psiExpression2 = this.myExpression;
            if (psiExpression2 instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)psiExpression2;
                if (VariableAccessUtils.variableIsAssigned((PsiVariable)variable)) {
                    return null;
                }
                psiExpression = variable.getInitializer();
            }
            if (psiExpression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)psiExpression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                int length = operands.length;
                for (int i = 0; i < length; ++i) {
                    PsiExpression operand = operands[i];
                    String stringPart = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)operand, (PsiType)formatType);
                    if (stringPart != null) {
                        if (i == 0) {
                            hasText = true;
                        }
                    } else {
                        return hasText ? builder.toString() : null;
                    }
                    builder.append(stringPart);
                }
            }
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNames";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/format/FormatDecode$FormatArgument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extract";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromPrintFormatAnnotation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AllValidator
    extends Validator {
        AllValidator() {
            super("");
        }

        @Override
        public boolean valid(PsiType type) {
            return true;
        }
    }
}

