/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.format;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.format.FormatPlaceholder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MessageFormatUtil {
    public static final CallMatcher PATTERN_METHODS = CallMatcher.anyOf(CallMatcher.staticCall("java.text.MessageFormat", "format").parameterCount(2));
    private static final Map<String, List<String>> knownContractions = Map.ofEntries(Map.entry("aren", List.of("t")), Map.entry("can", List.of("t")), Map.entry("couldn", List.of("t")), Map.entry("didn", List.of("t")), Map.entry("doesn", List.of("t")), Map.entry("don", List.of("t")), Map.entry("hadn", List.of("t")), Map.entry("hasn", List.of("t")), Map.entry("haven", List.of("t")), Map.entry("he", List.of("d", "ll", "s")), Map.entry("i", List.of("d", "ll", "m", "ve")), Map.entry("isn", List.of("t")), Map.entry("it", List.of("s")), Map.entry("mustn", List.of("t")), Map.entry("shan", List.of("t")), Map.entry("she", List.of("d", "ll", "s")), Map.entry("shouldn", List.of("t")), Map.entry("that", List.of("s")), Map.entry("there", List.of("s")), Map.entry("they", List.of("d", "ll", "re", "ve")), Map.entry("we", List.of("d", "re", "ve")), Map.entry("weren", List.of("t")), Map.entry("what", List.of("ll", "re", "s", "ve")), Map.entry("where", List.of("s")), Map.entry("who", List.of("d", "ll", "re", "s", "ve")), Map.entry("won", List.of("t")), Map.entry("wouldn", List.of("t")), Map.entry("you", List.of("d", "ll", "re", "ve")));

    @NotNull
    public static MessageFormatResult checkFormat(@NotNull String pattern) {
        if (pattern == null) {
            MessageFormatUtil.$$$reportNull$$$0(0);
        }
        if (pattern.isEmpty()) {
            return new MessageFormatResult(true, List.of(), List.of());
        }
        MessageHolder holder = MessageFormatUtil.parseMessageHolder(pattern);
        List<MessageFormatError> errors = holder.getErrors();
        List<MessageFormatPart> parts = holder.getParts();
        for (MessageFormatPart part : parts) {
            if (part.getParsedType() != MessageFormatParsedType.STRING) continue;
            String string = part.getText();
            List<MessageFormatError> doubleQuoteErrors = MessageFormatUtil.checkQuote(string);
            errors.addAll(MessageFormatUtil.rearrangeErrors(doubleQuoteErrors, pattern, string, part.start));
        }
        ArrayList<MessageFormatPlaceholder> placeholderIndexes = new ArrayList<MessageFormatPlaceholder>();
        for (MessageFormatPart part : parts) {
            if (part.getParsedType() != MessageFormatParsedType.FORMAT_ELEMENT || part.getMessageFormatElement() == null || part.getMessageFormatElement().getIndex() == null) continue;
            placeholderIndexes.add(new MessageFormatPlaceholder(part.getMessageFormatElement().getIndex(), part.getMessageFormatElement().formatType != null ? new TextRange(part.start, part.getMessageFormatElement().formatTypeSegmentStart) : new TextRange(part.start, part.start + part.text.length()), part.getMessageFormatElement().formatType == null && part.getMessageFormatElement().currentPart == MessageFormatElementPart.ARGUMENT_INDEX));
        }
        return new MessageFormatResult(errors.isEmpty(), errors, placeholderIndexes);
    }

    @NotNull
    private static List<MessageFormatError> rearrangeErrors(@NotNull List<MessageFormatError> errors, @NotNull String fullPattern, @NotNull String string, int start) {
        int i;
        if (errors == null) {
            MessageFormatUtil.$$$reportNull$$$0(1);
        }
        if (fullPattern == null) {
            MessageFormatUtil.$$$reportNull$$$0(2);
        }
        if (string == null) {
            MessageFormatUtil.$$$reportNull$$$0(3);
        }
        if (errors.isEmpty()) {
            List<MessageFormatError> list = errors;
            if (list == null) {
                MessageFormatUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        TreeMap<Integer, Integer> stringTranslation = new TreeMap<Integer, Integer>();
        stringTranslation.put(0, 0);
        TreeMap<Integer, Pair> fullPatternTranslation = new TreeMap<Integer, Pair>();
        int indexWithoutQuotes = 0;
        for (i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\'') {
                if (i - 1 >= 0 && string.charAt(i - 1) == '\'') {
                    stringTranslation.put(i, indexWithoutQuotes);
                }
                ++indexWithoutQuotes;
                continue;
            }
            if (i - 1 >= 0 && string.charAt(i - 1) == '\'') continue;
            stringTranslation.put(i, indexWithoutQuotes);
        }
        stringTranslation.put(string.length(), indexWithoutQuotes + 1);
        indexWithoutQuotes = 0;
        fullPatternTranslation.put(0, Pair.pair((Object)start, (Object)start));
        for (i = start; i < fullPattern.length(); ++i) {
            int to;
            if (fullPattern.charAt(i) != '\'') {
                ++indexWithoutQuotes;
                continue;
            }
            if (i - 1 >= 0 && fullPattern.charAt(i - 1) == '\'') continue;
            for (to = i; to < fullPattern.length() && fullPattern.charAt(to) == '\''; ++to) {
            }
            fullPatternTranslation.put(indexWithoutQuotes, Pair.pair((Object)i, (Object)to));
        }
        if (!fullPatternTranslation.containsKey(indexWithoutQuotes)) {
            fullPatternTranslation.put(indexWithoutQuotes + 1, Pair.pair((Object)fullPattern.length(), (Object)fullPattern.length()));
        }
        ArrayList<MessageFormatError> rearrangedErrors = new ArrayList<MessageFormatError>();
        for (MessageFormatError error : errors) {
            Integer fromIndex = error.fromIndex();
            Integer toIndex = error.toIndex();
            Integer floorFromIndex = stringTranslation.floorKey(fromIndex);
            Integer ceilToIndex = stringTranslation.ceilingKey(toIndex);
            if (floorFromIndex == null || ceilToIndex == null) continue;
            Integer convertedShiftedIndex = (Integer)stringTranslation.get(floorFromIndex);
            fromIndex = convertedShiftedIndex + (fromIndex - floorFromIndex);
            convertedShiftedIndex = (Integer)stringTranslation.get(ceilToIndex);
            toIndex = convertedShiftedIndex + (toIndex - ceilToIndex);
            if (toIndex.equals(fromIndex)) {
                Pair pair = (Pair)fullPatternTranslation.get(fromIndex);
                if (pair == null) continue;
                rearrangedErrors.add(new MessageFormatError(error.errorType(), (Integer)pair.first, (Integer)pair.second));
                continue;
            }
            floorFromIndex = fullPatternTranslation.floorKey(fromIndex);
            ceilToIndex = fullPatternTranslation.ceilingKey(toIndex);
            if (floorFromIndex == null || ceilToIndex == null) continue;
            Pair shifterPair = (Pair)fullPatternTranslation.get(floorFromIndex);
            fromIndex = (Integer)shifterPair.second + (fromIndex - floorFromIndex);
            shifterPair = (Pair)fullPatternTranslation.get(ceilToIndex);
            toIndex = (Integer)shifterPair.first + (toIndex - ceilToIndex);
            rearrangedErrors.add(new MessageFormatError(error.errorType(), fromIndex, toIndex));
        }
        ArrayList<MessageFormatError> arrayList = rearrangedErrors;
        if (arrayList == null) {
            MessageFormatUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static List<MessageFormatError> checkQuote(@NotNull String string) {
        int currentQuoteIndex;
        if (string == null) {
            MessageFormatUtil.$$$reportNull$$$0(6);
        }
        ArrayList<MessageFormatError> errors = new ArrayList<MessageFormatError>();
        int fromIndex = 0;
        while ((currentQuoteIndex = string.indexOf(39, fromIndex)) != -1) {
            int afterContradiction;
            for (afterContradiction = currentQuoteIndex; afterContradiction < string.length() && string.charAt(afterContradiction) == '\''; ++afterContradiction) {
            }
            if (afterContradiction >= string.length()) break;
            fromIndex = afterContradiction;
            if (currentQuoteIndex + 1 == afterContradiction) continue;
            String firstPartContradiction = new StringBuilder(MessageFormatUtil.getStringWord(string, currentQuoteIndex - 1, i -> i - 1)).reverse().toString();
            String secondPartContradiction = MessageFormatUtil.getStringWord(string, afterContradiction, i -> i + 1);
            List<String> knownSecondParts = knownContractions.get(firstPartContradiction.toLowerCase(Locale.ROOT));
            if (knownSecondParts == null || !knownSecondParts.contains(secondPartContradiction.toLowerCase(Locale.ROOT))) continue;
            errors.add(new MessageFormatError(MessageFormatErrorType.MANY_QUOTES, currentQuoteIndex, fromIndex));
        }
        ArrayList<MessageFormatError> arrayList = errors;
        if (arrayList == null) {
            MessageFormatUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static String getStringWord(@NotNull String string, int from, @NotNull Int2IntFunction nextIntFun) {
        if (string == null) {
            MessageFormatUtil.$$$reportNull$$$0(8);
        }
        if (nextIntFun == null) {
            MessageFormatUtil.$$$reportNull$$$0(9);
        }
        StringBuilder builder = new StringBuilder();
        int nextInt = from;
        while (nextInt >= 0 && nextInt < string.length() && Character.isLetter(string.charAt(nextInt))) {
            builder.append(string.charAt(nextInt));
            nextInt = nextIntFun.applyAsInt(nextInt);
        }
        String string2 = builder.toString();
        if (string2 == null) {
            MessageFormatUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static MessageHolder parseMessageHolder(@NotNull String pattern) {
        if (pattern == null) {
            MessageFormatUtil.$$$reportNull$$$0(11);
        }
        MessageHolder holder = new MessageHolder(pattern);
        block7: while (!holder.hasRuntimeError && holder.hasNext()) {
            char ch = holder.nextPool();
            if (holder.getLastPart().getParsedType() == MessageFormatParsedType.STRING) {
                if (ch == '\'') {
                    if (holder.hasNext() && holder.nextPeek() == '\'') {
                        holder.addChar(ch);
                        holder.nextPool();
                        continue;
                    }
                    holder.inQuote = !holder.inQuote;
                    holder.lastQuoteIndex = holder.current;
                    continue;
                }
                if (ch == '{') {
                    if (holder.inQuote) {
                        int end = MessageFormatUtil.findEndOfQuotedPlaceholder(pattern, holder.current);
                        if (end != -1) {
                            holder.addError(MessageFormatErrorType.QUOTED_PLACEHOLDER, holder.current, end);
                        }
                        holder.addChar(ch);
                        continue;
                    }
                    holder.startFormatElement(ch);
                    continue;
                }
                holder.addChar(ch);
                continue;
            }
            if (holder.inQuote) {
                if (ch == '\'') {
                    holder.inQuote = false;
                }
                holder.addChar(ch);
                continue;
            }
            switch (ch) {
                case ',': {
                    if (holder.moveSegmentOfFormatElement()) continue block7;
                    holder.addChar(ch);
                    break;
                }
                case '{': {
                    ++holder.braceStack;
                    holder.addChar(ch);
                    break;
                }
                case ' ': {
                    MessageFormatPart part = holder.getLastPart();
                    if (part.getMessageFormatElement() != null && part.getMessageFormatElement().currentPart == MessageFormatElementPart.FORMAT_TYPE && part.getMessageFormatElement().formatTypeSegment.isEmpty()) continue block7;
                    holder.addChar(ch);
                    break;
                }
                case '}': {
                    if (holder.braceStack != 0) {
                        --holder.braceStack;
                        holder.addChar(ch);
                        break;
                    }
                    holder.finishFormatElement(ch);
                    break;
                }
                case '\'': {
                    holder.inQuote = true;
                    holder.lastQuoteIndex = holder.current;
                    holder.addChar(ch);
                    break;
                }
                default: {
                    holder.addChar(ch);
                }
            }
        }
        MessageFormatPart lastPart = holder.getLastPart();
        if (holder.inQuote) {
            holder.addError(MessageFormatErrorType.UNPAIRED_QUOTE, holder.lastQuoteIndex, holder.lastQuoteIndex + 1);
        }
        if (lastPart.getMessageFormatElement() != null && holder.braceStack == 0 && holder.getLastPart().parsedType != MessageFormatParsedType.STRING) {
            holder.addError(MessageFormatErrorType.UNMATCHED_BRACE, lastPart.getMessageFormatElement().indexSegmentStart - 1, lastPart.getMessageFormatElement().indexSegmentStart);
        } else if (lastPart.getMessageFormatElement() != null && !lastPart.getMessageFormatElement().finished) {
            holder.addError(MessageFormatErrorType.UNCLOSED_BRACE_PLACEHOLDER, lastPart.getMessageFormatElement().indexSegmentStart - 1, lastPart.getMessageFormatElement().indexSegmentStart);
        }
        MessageHolder messageHolder = holder;
        if (messageHolder == null) {
            MessageFormatUtil.$$$reportNull$$$0(12);
        }
        return messageHolder;
    }

    private static int findEndOfQuotedPlaceholder(@NotNull String pattern, int current) {
        int nextQuote;
        if (pattern == null) {
            MessageFormatUtil.$$$reportNull$$$0(13);
        }
        if (current - 1 < 0 || pattern.charAt(current - 1) != '\'') {
            return -1;
        }
        String nextPattern = pattern.substring(current);
        int from = 0;
        while (true) {
            if ((nextQuote = nextPattern.indexOf(39, from)) == -1) {
                return -1;
            }
            if (nextPattern.length() <= nextQuote + 1 || nextPattern.charAt(nextQuote + 1) != '\'') break;
            from = nextQuote + 2;
        }
        if ((nextPattern = nextPattern.substring(0, nextQuote)).startsWith("{") && nextPattern.endsWith("}") && nextPattern.indexOf("}") == nextPattern.length() - 1) {
            List notStrings;
            MessageHolder holder = MessageFormatUtil.parseMessageHolder(nextPattern);
            if (holder.errors.isEmpty() && (notStrings = ContainerUtil.filter(holder.parts, t -> t.getParsedType() != MessageFormatParsedType.STRING || !t.getText().isEmpty())).size() == 1 && ((MessageFormatPart)notStrings.getFirst()).getParsedType() == MessageFormatParsedType.FORMAT_ELEMENT) {
                return nextQuote + current;
            }
        }
        return -1;
    }

    @NotNull
    private static MessageHolder parseChoice(@NotNull String patten) {
        if (patten == null) {
            MessageFormatUtil.$$$reportNull$$$0(14);
        }
        MessageHolder holder = new MessageHolder(patten);
        holder.parts.clear();
        holder.startNumberElement();
        ArrayList<Double> selectors = new ArrayList<Double>();
        ArrayList<Integer> startIndexes = new ArrayList<Integer>();
        startIndexes.add(0);
        while (holder.hasNext() && !holder.hasRuntimeError) {
            char ch = holder.nextPool();
            if (ch == '\'') {
                if (holder.hasNext() && holder.nextPeek() == '\'') {
                    holder.addChar(ch);
                    holder.nextPool();
                    continue;
                }
                holder.inQuote = !holder.inQuote;
                continue;
            }
            if (holder.inQuote) {
                holder.addChar(ch);
                continue;
            }
            if (ch == '<' || ch == '#' || ch == '\u2264') {
                MessageFormatPart part = holder.getLastPart();
                String selector = part.text.toString();
                if (part.getParsedType() != MessageFormatParsedType.NUMBER || selector.isEmpty()) {
                    holder.addError(MessageFormatErrorType.SELECTOR_NOT_FOUND, holder.current, holder.current + 1);
                } else if (!selector.equals("\u221e") && !selector.equals("-\u221e")) {
                    try {
                        Double previousSelector;
                        double currentSelector = Double.parseDouble(selector);
                        if (ch == '<') {
                            currentSelector = ChoiceFormat.nextDouble(currentSelector);
                        }
                        if (!selectors.isEmpty() && (previousSelector = (Double)selectors.getLast()) >= currentSelector) {
                            holder.addError(MessageFormatErrorType.INCORRECT_ORDER_CHOICE_SELECTOR, holder.current - selector.length(), holder.current);
                        }
                        selectors.add(currentSelector);
                    }
                    catch (NumberFormatException e) {
                        holder.addError(MessageFormatErrorType.INCORRECT_CHOICE_SELECTOR, holder.current - selector.length(), holder.current);
                    }
                }
                startIndexes.add(holder.current + 1);
                holder.startStringElement();
                continue;
            }
            if (ch == '|') {
                startIndexes.add(holder.current + 1);
                holder.startNumberElement();
                continue;
            }
            holder.addChar(ch);
        }
        ArrayList<MessageFormatPart> parts = new ArrayList<MessageFormatPart>(holder.getParts());
        holder.parts.clear();
        for (int i = 0; !holder.hasRuntimeError && i < parts.size(); ++i) {
            MessageFormatPart part = (MessageFormatPart)parts.get(i);
            String currentSubPattern = part.getText();
            if (part.getParsedType() == MessageFormatParsedType.STRING && currentSubPattern.indexOf(123) >= 0) {
                holder.merge(MessageFormatUtil.parseMessageHolder(currentSubPattern), (Integer)startIndexes.get(i));
                continue;
            }
            holder.parts.add(part);
        }
        MessageHolder messageHolder = holder;
        if (messageHolder == null) {
            MessageFormatUtil.$$$reportNull$$$0(15);
        }
        return messageHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 10, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPattern";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextIntFun";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patten";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rearrangeErrors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkQuote";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringWord";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMessageHolder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseChoice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFormat";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeErrors";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkQuote";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStringWord";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseMessageHolder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findEndOfQuotedPlaceholder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseChoice";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 10, 12, 15 -> new IllegalStateException(string);
        };
    }

    public record MessageFormatResult(boolean valid, @NotNull List<MessageFormatError> errors, @NotNull List<MessageFormatPlaceholder> placeholders) {
        @NotNull
        private final List<MessageFormatError> errors;
        @NotNull
        private final List<MessageFormatPlaceholder> placeholders;

        public MessageFormatResult(boolean valid, @NotNull List<MessageFormatError> errors, @NotNull List<MessageFormatPlaceholder> placeholders) {
            if (errors == null) {
                MessageFormatResult.$$$reportNull$$$0(0);
            }
            if (placeholders == null) {
                MessageFormatResult.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public List<MessageFormatError> errors() {
            List<MessageFormatError> list = this.errors;
            if (list == null) {
                MessageFormatResult.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<MessageFormatPlaceholder> placeholders() {
            List<MessageFormatPlaceholder> list = this.placeholders;
            if (list == null) {
                MessageFormatResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placeholders";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeholders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class MessageHolder {
        private final String pattern;
        private final List<MessageFormatPart> parts;
        private final List<MessageFormatError> errors;
        private boolean hasRuntimeError;
        private int current;
        private int braceStack;
        private boolean inQuote;
        private int lastQuoteIndex;

        private MessageHolder(@NotNull String pattern) {
            if (pattern == null) {
                MessageHolder.$$$reportNull$$$0(0);
            }
            this.parts = new ArrayList<MessageFormatPart>();
            this.errors = new ArrayList<MessageFormatError>();
            this.hasRuntimeError = false;
            this.current = -1;
            this.braceStack = 0;
            this.inQuote = false;
            this.lastQuoteIndex = -1;
            this.pattern = pattern;
            this.parts.add(new MessageFormatPart(0, MessageFormatParsedType.STRING, null));
        }

        public List<MessageFormatPart> getParts() {
            return this.parts;
        }

        public List<MessageFormatError> getErrors() {
            return this.errors;
        }

        boolean hasNext() {
            return this.current + 1 < this.pattern.length();
        }

        char nextPool() {
            return this.pattern.charAt(++this.current);
        }

        char nextPeek() {
            return this.pattern.charAt(this.current + 1);
        }

        private void startStringElement() {
            this.parts.add(new MessageFormatPart(this.current + 1, MessageFormatParsedType.STRING, null));
        }

        private void startNumberElement() {
            this.parts.add(new MessageFormatPart(this.current, MessageFormatParsedType.NUMBER, null));
        }

        @NotNull
        private MessageFormatPart getLastPart() {
            MessageFormatPart messageFormatPart = this.parts.getLast();
            if (messageFormatPart == null) {
                MessageHolder.$$$reportNull$$$0(1);
            }
            return messageFormatPart;
        }

        private void startFormatElement(char ch) {
            MessageFormatElement element = new MessageFormatElement();
            element.indexSegmentStart = this.current + 1;
            MessageFormatPart messageFormatPart = new MessageFormatPart(this.current, MessageFormatParsedType.FORMAT_ELEMENT, element);
            this.parts.add(messageFormatPart);
            messageFormatPart.text.append(ch);
        }

        private void addChar(char ch) {
            this.getLastPart().add(ch);
        }

        private boolean moveSegmentOfFormatElement() {
            MessageFormatPart part = this.getLastPart();
            if (part.parsedType != MessageFormatParsedType.FORMAT_ELEMENT || part.messageFormatElement == null || !part.messageFormatElement.tryMoveSegment(this)) {
                return false;
            }
            part.text.append(',');
            return true;
        }

        private void finishFormatElement(char ch) {
            MessageFormatPart part = this.getLastPart();
            part.text.append(ch);
            if (part.messageFormatElement != null) {
                part.messageFormatElement.finish(this);
            }
            this.startStringElement();
        }

        private void addError(@NotNull MessageFormatErrorType errorType, int from, int until) {
            if (errorType == null) {
                MessageHolder.$$$reportNull$$$0(2);
            }
            if (!this.hasRuntimeError) {
                this.errors.add(new MessageFormatError(errorType, from, until));
            }
            if (errorType.severity == ErrorSeverity.RUNTIME_EXCEPTION) {
                this.hasRuntimeError = true;
            }
        }

        private void merge(@NotNull MessageHolder subHolder, int start) {
            if (subHolder == null) {
                MessageHolder.$$$reportNull$$$0(3);
            }
            List<MessageFormatError> errors = subHolder.getErrors();
            for (MessageFormatError error : MessageFormatUtil.rearrangeErrors(errors, this.pattern, subHolder.pattern, start)) {
                this.addError(error.errorType, error.fromIndex, error.toIndex);
            }
            for (MessageFormatPart part : subHolder.parts) {
                part.start += start;
                MessageFormatElement nestedMessageFormatElement = part.messageFormatElement;
                if (nestedMessageFormatElement != null) {
                    nestedMessageFormatElement.indexSegmentStart += start;
                    nestedMessageFormatElement.formatTypeSegmentStart += start;
                    nestedMessageFormatElement.formatStyleSegmentStart += start;
                }
                this.parts.add(part);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil$MessageHolder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addError";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class MessageFormatPart {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final MessageFormatParsedType parsedType;
        @Nullable
        private final MessageFormatElement messageFormatElement;
        private int start;

        private MessageFormatPart(int start, @NotNull MessageFormatParsedType type, @Nullable MessageFormatElement element) {
            if (type == null) {
                MessageFormatPart.$$$reportNull$$$0(0);
            }
            this.text = new StringBuilder();
            this.start = start;
            this.parsedType = type;
            this.messageFormatElement = element;
        }

        @Nullable
        public MessageFormatElement getMessageFormatElement() {
            return this.messageFormatElement;
        }

        @VisibleForTesting
        public String getText() {
            return this.text.toString();
        }

        @NotNull
        public MessageFormatParsedType getParsedType() {
            MessageFormatParsedType messageFormatParsedType = this.parsedType;
            if (messageFormatParsedType == null) {
                MessageFormatPart.$$$reportNull$$$0(1);
            }
            return messageFormatParsedType;
        }

        private void add(char ch) {
            this.text.append(ch);
            if (this.messageFormatElement != null) {
                this.messageFormatElement.add(ch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatPart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParsedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static enum MessageFormatParsedType {
        STRING,
        FORMAT_ELEMENT,
        NUMBER;

    }

    @ApiStatus.Internal
    public static final class MessageFormatElement {
        private final StringBuilder indexSegment = new StringBuilder();
        private final StringBuilder formatTypeSegment = new StringBuilder();
        private final StringBuilder formatStyleSegment = new StringBuilder();
        private boolean finished = false;
        private MessageFormatElementPart currentPart = MessageFormatElementPart.ARGUMENT_INDEX;
        private int indexSegmentStart = 0;
        private int formatTypeSegmentStart = 0;
        private int formatStyleSegmentStart = 0;
        @Nullable
        private Integer index;
        @Nullable
        private MessageFormatType formatType;

        @Nullable
        public Integer getIndex() {
            return this.index;
        }

        private boolean tryMoveSegment(@NotNull MessageHolder holder) {
            if (holder == null) {
                MessageFormatElement.$$$reportNull$$$0(0);
            }
            if (this.currentPart == MessageFormatElementPart.ARGUMENT_INDEX) {
                this.formatTypeSegmentStart = holder.current + 1;
                this.currentPart = MessageFormatElementPart.FORMAT_TYPE;
                return true;
            }
            if (this.currentPart == MessageFormatElementPart.FORMAT_TYPE) {
                this.formatStyleSegmentStart = holder.current + 1;
                this.currentPart = MessageFormatElementPart.FORMAT_STYLE;
                return true;
            }
            return false;
        }

        private void add(char ch) {
            switch (this.currentPart.ordinal()) {
                case 0: {
                    this.indexSegment.append(ch);
                    break;
                }
                case 1: {
                    this.formatTypeSegment.append(ch);
                    break;
                }
                case 2: {
                    this.formatStyleSegment.append(ch);
                }
            }
        }

        private void finish(@NotNull MessageHolder holder) {
            if (holder == null) {
                MessageFormatElement.$$$reportNull$$$0(1);
            }
            this.finished = true;
            try {
                this.index = Integer.parseInt(this.indexSegment.toString());
                if (this.index < 0) {
                    holder.addError(MessageFormatErrorType.INDEX_NEGATIVE, this.indexSegmentStart, this.indexSegmentStart + this.indexSegment.length());
                }
            }
            catch (NumberFormatException e) {
                holder.addError(MessageFormatErrorType.UNPARSED_INDEX, this.indexSegmentStart, this.indexSegmentStart + this.indexSegment.length());
            }
            if (!this.formatTypeSegment.isEmpty()) {
                String typeSegment = this.formatTypeSegment.toString();
                for (MessageFormatType value : MessageFormatType.values()) {
                    if (!value.name().equals(typeSegment.trim().toUpperCase(Locale.ROOT))) continue;
                    this.formatType = value;
                }
                if (this.formatType == null) {
                    if (this.formatStyleSegmentStart >= this.formatTypeSegmentStart) {
                        holder.addError(MessageFormatErrorType.UNKNOWN_FORMAT_TYPE, this.formatTypeSegmentStart, this.formatStyleSegmentStart - 1);
                    } else {
                        holder.addError(MessageFormatErrorType.UNKNOWN_FORMAT_TYPE, this.formatTypeSegmentStart, holder.current);
                    }
                }
            }
            this.tryParseStyle(holder);
        }

        private void tryParseStyle(@NotNull MessageHolder holder) {
            if (holder == null) {
                MessageFormatElement.$$$reportNull$$$0(2);
            }
            if (this.formatType != null) {
                switch (this.formatType.ordinal()) {
                    case 3: {
                        MessageHolder choiceHolder = MessageFormatUtil.parseChoice(this.formatStyleSegment.toString());
                        holder.merge(choiceHolder, this.formatStyleSegmentStart);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("formatType: " + String.valueOf((Object)this.formatType));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "holder";
            objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMoveSegment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finish";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryParseStyle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public record MessageFormatPlaceholder(int index, @NotNull TextRange range, boolean isString) implements FormatPlaceholder
    {
        @NotNull
        private final TextRange range;

        public MessageFormatPlaceholder(int index, @NotNull TextRange range, boolean isString) {
            if (range == null) {
                MessageFormatPlaceholder.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public TextRange range() {
            TextRange textRange = this.range;
            if (textRange == null) {
                MessageFormatPlaceholder.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatPlaceholder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatPlaceholder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static enum MessageFormatType {
        NUMBER,
        DATE,
        TIME,
        CHOICE;

    }

    static enum MessageFormatElementPart {
        ARGUMENT_INDEX,
        FORMAT_TYPE,
        FORMAT_STYLE;

    }

    public record MessageFormatError(@NotNull MessageFormatErrorType errorType, int fromIndex, int toIndex) {
        @NotNull
        private final MessageFormatErrorType errorType;

        public MessageFormatError(@NotNull MessageFormatErrorType errorType, int fromIndex, int toIndex) {
            if (errorType == null) {
                MessageFormatError.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public MessageFormatErrorType errorType() {
            MessageFormatErrorType messageFormatErrorType = this.errorType;
            if (messageFormatErrorType == null) {
                MessageFormatError.$$$reportNull$$$0(1);
            }
            return messageFormatErrorType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/format/MessageFormatUtil$MessageFormatError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errorType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static enum MessageFormatErrorType {
        QUOTED_PLACEHOLDER(ErrorSeverity.WEAK_WARNING),
        UNPARSED_INDEX(ErrorSeverity.RUNTIME_EXCEPTION),
        INDEX_NEGATIVE(ErrorSeverity.RUNTIME_EXCEPTION),
        UNKNOWN_FORMAT_TYPE(ErrorSeverity.RUNTIME_EXCEPTION),
        UNCLOSED_BRACE_PLACEHOLDER(ErrorSeverity.WARNING),
        UNPAIRED_QUOTE(ErrorSeverity.WARNING),
        UNMATCHED_BRACE(ErrorSeverity.RUNTIME_EXCEPTION),
        MANY_QUOTES(ErrorSeverity.WEAK_WARNING),
        INCORRECT_CHOICE_SELECTOR(ErrorSeverity.RUNTIME_EXCEPTION),
        SELECTOR_NOT_FOUND(ErrorSeverity.RUNTIME_EXCEPTION),
        INCORRECT_ORDER_CHOICE_SELECTOR(ErrorSeverity.RUNTIME_EXCEPTION);

        private final ErrorSeverity severity;

        private MessageFormatErrorType(ErrorSeverity severity) {
            if (severity == null) {
                MessageFormatErrorType.$$$reportNull$$$0(0);
            }
            this.severity = severity;
        }

        public ErrorSeverity getSeverity() {
            return this.severity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/siyeh/ig/format/MessageFormatUtil$MessageFormatErrorType", "<init>"));
        }
    }

    public static enum ErrorSeverity {
        RUNTIME_EXCEPTION,
        WARNING,
        WEAK_WARNING;

    }
}

