/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public final class AbstractClassNeverImplementedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.class.never.implemented.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractClassNeverImplementedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassNeverImplementedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractClassNeverImplementedInspection", "buildErrorString"));
    }

    private static class AbstractClassNeverImplementedVisitor
    extends BaseInspectionVisitor {
        private AbstractClassNeverImplementedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                AbstractClassNeverImplementedVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass.isDeprecated()) {
                return;
            }
            if (InheritanceUtil.hasImplementation(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/AbstractClassNeverImplementedInspection$AbstractClassNeverImplementedVisitor", "visitClass"));
        }
    }
}

