/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ChangeModifierFix;
import org.jetbrains.annotations.NotNull;

public final class NonProtectedConstructorInAbstractClassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreNonPublicClasses = false;

    @NotNull
    public String getID() {
        return "ConstructorNotProtectedInAbstractClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.problem.descriptor", new Object[0]);
        if (string == null) {
            NonProtectedConstructorInAbstractClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreNonPublicClasses", (String)InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NonProtectedConstructorInAbstractClassInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonProtectedConstructorInAbstractClassVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ChangeModifierFix("protected");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonProtectedConstructorInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NonProtectedConstructorInAbstractClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonProtectedConstructorInAbstractClassVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("protected") || method.hasModifierProperty("private") || method.hasModifierProperty("packageLocal")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (NonProtectedConstructorInAbstractClassInspection.this.m_ignoreNonPublicClasses && !containingClass.hasModifierProperty("public")) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection$NonProtectedConstructorInAbstractClassVisitor", "visitMethod"));
        }
    }
}

