/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterTypePreventsOverridingInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String qualifiedName1 = (String)infos[0];
        String packageName = StringUtil.getPackageName((String)qualifiedName1);
        String qualifiedName2 = (String)infos[1];
        String superPackageName = StringUtil.getPackageName((String)qualifiedName2);
        String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.problem.descriptor", packageName, superPackageName);
        if (string == null) {
            ParameterTypePreventsOverridingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ParameterTypePreventsOverridingFix((String)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterTypePreventsOverridingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection", "buildErrorString"));
    }

    private static class ParameterTypePreventsOverridingFix
    extends PsiUpdateModCommandQuickFix {
        private final String myNewTypeText;

        ParameterTypePreventsOverridingFix(String newTypeText) {
            this.myNewTypeText = newTypeText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.quickfix", this.myNewTypeText);
            if (string == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.family.quickfix", new Object[0]);
            if (string == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)typeElement.getProject());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(this.myNewTypeText, (PsiElement)typeElement);
            typeElement.replace((PsiElement)newTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ParameterTypePreventsOverridingVisitor
    extends BaseInspectionVisitor {
        private ParameterTypePreventsOverridingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                ParameterTypePreventsOverridingVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass superClass = containingClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            String name = method.getName();
            block0: for (PsiMethod superMethod : superMethods = superClass.findMethodsByName(name, true)) {
                PsiType type;
                PsiParameterList superParameterList;
                PsiType superReturnType = superMethod.getReturnType();
                if (superReturnType == null || !superReturnType.isAssignableFrom(returnType) || (superParameterList = superMethod.getParameterList()).getParametersCount() != parameterCount) continue;
                PsiParameter[] superParameters = superParameterList.getParameters();
                HashMap<PsiTypeElement, PsiClassType> problemTypeElements = new HashMap<PsiTypeElement, PsiClassType>(2);
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    PsiParameter superParameter = superParameters[i];
                    type = parameter.getType();
                    PsiType superType = superParameter.getType();
                    if (!(superType instanceof PsiClassType) || type.equals(superType)) continue;
                    if (!(type instanceof PsiClassType) || !type.getPresentableText().equals(superType.getPresentableText())) {
                        return;
                    }
                    PsiTypeElement typeElement = parameter.getTypeElement();
                    if (typeElement == null) {
                        return;
                    }
                    PsiTypeElement superParameterTypeElement = superParameter.getTypeElement();
                    if (superParameterTypeElement == null) continue block0;
                    problemTypeElements.put(typeElement, (PsiClassType)superType);
                }
                for (Map.Entry entry : problemTypeElements.entrySet()) {
                    PsiTypeElement typeElement = (PsiTypeElement)entry.getKey();
                    type = (PsiClassType)typeElement.getType();
                    PsiClass aClass1 = type.resolve();
                    if (aClass1 == null || aClass1 instanceof PsiTypeParameter) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)entry.getValue();
                    PsiClass aClass2 = classType.resolve();
                    if (aClass2 == null || aClass2 instanceof PsiTypeParameter) continue;
                    this.registerError((PsiElement)typeElement, type.getCanonicalText(), classType.getCanonicalText());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingVisitor", "visitMethod"));
        }
    }
}

