/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import org.jetbrains.annotations.NotNull;

public final class ProblematicVarargsMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("problematic.varargs.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            ProblematicVarargsMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ConvertToVarargsMethodFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonVarargsMethodOverridesVarArgsMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ProblematicVarargsMethodOverrideInspection", "buildErrorString"));
    }

    private static class NonVarargsMethodOverridesVarArgsMethodVisitor
    extends BaseInspectionVisitor {
        private NonVarargsMethodOverridesVarArgsMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonVarargsMethodOverridesVarArgsMethodVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter parameter = parameters[parameters.length - 1];
            PsiType type = parameter.getType();
            if (!(type instanceof PsiArrayType) || type instanceof PsiEllipsisType) {
                return;
            }
            for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
                if (!superMethod.isVarArgs()) continue;
                PsiIdentifier nameIdentifier = method.getNameIdentifier();
                if (nameIdentifier != null) {
                    this.registerMethodError(method, new Object[0]);
                }
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/ProblematicVarargsMethodOverrideInspection$NonVarargsMethodOverridesVarArgsMethodVisitor", "visitMethod"));
        }
    }
}

