/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import org.jetbrains.annotations.NotNull;

public final class StaticVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "StaticVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticVariableInitializationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignorePrimitives", (String)InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StaticVariableInitializationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/StaticVariableInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiType type;
            if (field == null) {
                StaticVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass.isEnum()) {
                return;
            }
            if (StaticVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type = field.getType())) {
                return;
            }
            for (PsiClassInitializer initializer : initializers = containingClass.getInitializers()) {
                PsiCodeBlock body;
                if (!initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/initialization/StaticVariableInitializationInspection$StaticVariableInitializationVisitor", "visitField"));
        }
    }
}

