/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class CheckForOutOfMemoryOnLargeArrayAllocationInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.problem.descriptor", new Object[0]);
        if (string == null) {
            CheckForOutOfMemoryOnLargeArrayAllocationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.maximum.number.of.elements.option", new Object[0]), (int)1, (int)0x7FFFFFFE)});
        if (optPane == null) {
            CheckForOutOfMemoryOnLargeArrayAllocationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CheckForOutOfMemoryOnLargeArrayAllocationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CheckForOutOfMemoryOnLargeArrayAllocationVisitor
    extends BaseInspectionVisitor {
        private CheckForOutOfMemoryOnLargeArrayAllocationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] dimensions;
            if (expression == null) {
                CheckForOutOfMemoryOnLargeArrayAllocationVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            int size = 1;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                Integer intValue = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)dimension, (PsiType)PsiTypes.intType());
                if (intValue == null) continue;
                size *= intValue.intValue();
            }
            if (size <= CheckForOutOfMemoryOnLargeArrayAllocationInspection.this.m_limit) {
                return;
            }
            if (this.outOfMemoryExceptionCaught((PsiElement)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        private boolean outOfMemoryExceptionCaught(PsiElement element) {
            PsiElement currentElement = element;
            PsiTryStatement containingTryStatement;
            while ((containingTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class)) != null) {
                if (CheckForOutOfMemoryOnLargeArrayAllocationVisitor.catchesOutOfMemoryException(containingTryStatement)) {
                    return true;
                }
                currentElement = containingTryStatement;
            }
            return false;
        }

        private static boolean catchesOutOfMemoryException(PsiTryStatement statement) {
            PsiCatchSection[] sections;
            for (PsiCatchSection section : sections = statement.getCatchSections()) {
                String typeText;
                PsiType catchType = section.getCatchType();
                if (catchType == null || !"java.lang.OutOfMemoryError".equals(typeText = catchType.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection$CheckForOutOfMemoryOnLargeArrayAllocationVisitor", "visitNewExpression"));
        }
    }
}

