/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SingleCharacterStartsWithInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.character.startswith.problem.descriptor", new Object[0]);
        if (string == null) {
            SingleCharacterStartsWithInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SingleCharacterStartsWithFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SingleCharacterStartsWithVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection", "buildErrorString"));
    }

    private static class SingleCharacterStartsWithFix
    extends PsiUpdateModCommandQuickFix {
        private SingleCharacterStartsWithFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.character.startswith.quickfix", new Object[0]);
            if (string == null) {
                SingleCharacterStartsWithFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethod[] isEmptyMethod;
            if (project == null) {
                SingleCharacterStartsWithFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SingleCharacterStartsWithFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SingleCharacterStartsWithFix.$$$reportNull$$$0(3);
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)element.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCall.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            PsiExpression expression = expressions[0];
            String expressionText = expression.getText();
            String character = expressionText.substring(1, expressionText.length() - 1);
            if (character.equals("'")) {
                character = "\\'";
            }
            String qualifierText = qualifier.getText();
            @NonNls StringBuilder newExpression = new StringBuilder();
            PsiClass stringClass = ClassUtils.findClass("java.lang.String", qualifier);
            PsiMethod[] psiMethodArray = isEmptyMethod = stringClass == null ? PsiMethod.EMPTY_ARRAY : stringClass.findMethodsByName("isEmpty", false);
            if (isEmptyMethod.length > 0) {
                newExpression.append("!").append(qualifierText).append(".isEmpty() && ");
            } else {
                newExpression.append(qualifierText).append(".length() > 0 && ");
            }
            String referenceName = methodExpression.getReferenceName();
            newExpression.append(qualifierText).append(".charAt(");
            if ("startsWith".equals(referenceName)) {
                newExpression.append("0) == '");
            } else {
                newExpression.append(qualifierText).append(".length() - 1) == '");
            }
            newExpression.append(character).append('\'');
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(qualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection$SingleCharacterStartsWithFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection$SingleCharacterStartsWithFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SingleCharacterStartsWithVisitor
    extends BaseInspectionVisitor {
        private SingleCharacterStartsWithVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                SingleCharacterStartsWithVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"startsWith".equals(methodName) && !"endsWith".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1 && args.length != 2) {
                return;
            }
            if (!SingleCharacterStartsWithVisitor.isSingleCharacterStringLiteral(args[0])) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isSingleCharacterStringLiteral(PsiExpression arg) {
            PsiType type = arg.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return false;
            }
            if (!(arg instanceof PsiLiteralExpression)) {
                return false;
            }
            PsiLiteralExpression literal = (PsiLiteralExpression)arg;
            String value = (String)literal.getValue();
            return value != null && value.length() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection$SingleCharacterStartsWithVisitor", "visitMethodCallExpression"));
        }
    }
}

