/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MissingDeprecatedAnnotationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean warnOnMissingJavadoc = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean annotationWarning = infos[0] == Boolean.TRUE;
        String string = annotationWarning ? InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("missing.deprecated.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"warnOnMissingJavadoc", (String)InspectionGadgetsBundle.message("missing.deprecated.tag.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        boolean annotationWarning = infos[0] == Boolean.TRUE;
        return annotationWarning ? new MissingDeprecatedAnnotationFix() : new MissingDeprecatedTagFix();
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ANNOTATIONS);
        if (set == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MissingDeprecatedAnnotationFix
    extends PsiUpdateModCommandQuickFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement identifier, @NotNull ModPsiUpdater updater) {
            PsiModifierListOwner parent;
            if (project == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(1);
            }
            if (identifier == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(3);
            }
            if ((parent = (PsiModifierListOwner)identifier.getParent()) == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Deprecated", (PsiElement)parent);
            PsiModifierList modifierList = parent.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MissingDeprecatedTagFix
    extends PsiUpdateModCommandQuickFix {
        @NonNls
        private static final String DEPRECATED_TAG_NAME = "deprecated";
        private static final String TEXT = " TODO: explain";

        private MissingDeprecatedTagFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missing.add.deprecated.javadoc.tag.quickfix", new Object[0]);
            if (string == null) {
                MissingDeprecatedTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                MissingDeprecatedTagFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MissingDeprecatedTagFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MissingDeprecatedTagFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiJavaDocumentedElement)) {
                return;
            }
            PsiJavaDocumentedElement documentedElement = (PsiJavaDocumentedElement)parent;
            PsiDocComment docComment = documentedElement.getDocComment();
            if (docComment != null) {
                PsiDocTag existingTag = docComment.findTagByName(DEPRECATED_TAG_NAME);
                PsiDocTag deprecatedTag = JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText("@deprecated TODO: explain");
                PsiDocTag addedTag = existingTag != null ? (PsiDocTag)existingTag.replace((PsiElement)deprecatedTag) : (PsiDocTag)docComment.add((PsiElement)deprecatedTag);
                updater.moveCaretTo(addedTag.getTextRange().getStartOffset());
            } else {
                @NlsSafe PsiDocComment newDocComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(StringUtil.join((String[])new String[]{"/**\n", " * ", "@deprecated TODO: explain", "\n */"}));
                PsiDocComment addedComment = (PsiDocComment)documentedElement.addBefore((PsiElement)newDocComment, documentedElement.getFirstChild());
                PsiDocTag addedTag = addedComment.findTagByName(DEPRECATED_TAG_NAME);
                if (addedTag != null) {
                    updater.moveCaretTo(addedTag.getTextRange().getStartOffset());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedTagFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        public void visitModule(@NotNull PsiJavaModule module) {
            if (module == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitModule(module);
            if (MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)module)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)module, true)) {
                    this.registerModuleError(module, Boolean.FALSE);
                }
            } else if (MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)module, false)) {
                this.registerModuleError(module, Boolean.TRUE);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(1);
            }
            super.visitClass(aClass);
            if (MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)aClass)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, true)) {
                    this.registerClassError(aClass, Boolean.FALSE);
                }
            } else if (MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, false)) {
                this.registerClassError(aClass, Boolean.TRUE);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(2);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)method)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc) {
                    PsiMethod m = method;
                    while (m != null) {
                        if (MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)m, true)) {
                            return;
                        }
                        m = MethodUtils.getSuper(m);
                    }
                    this.registerMethodError(method, Boolean.FALSE);
                }
            } else if (MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)method, false)) {
                this.registerMethodError(method, Boolean.TRUE);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(3);
            }
            if (MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)field)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)field, true)) {
                    this.registerFieldError(field, Boolean.FALSE);
                }
            } else if (MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiJavaDocumentedElement)field, false)) {
                this.registerFieldError(field, Boolean.TRUE);
            }
        }

        private static boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.hasAnnotation("java.lang.Deprecated");
        }

        private static boolean hasDeprecatedComment(PsiJavaDocumentedElement documentedElement, boolean checkContent) {
            PsiDocComment comment = documentedElement.getDocComment();
            if (comment == null || !JavaDocUtil.shouldRunInspectionOnOldMarkdownComment((PsiDocComment)comment)) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            if (deprecatedTag == null) {
                return false;
            }
            if (!checkContent) {
                return true;
            }
            for (PsiElement element : deprecatedTag.getDataElements()) {
                if (!(element instanceof PsiDocTagValue) && !PsiDocToken.isDocToken((PsiElement)element, (IElementType)JavaDocTokenType.DOC_COMMENT_DATA)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

