/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AutoUnboxingInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_unboxingMethods = Map.of("byte", "byteValue", "short", "shortValue", "int", "intValue", "long", "longValue", "float", "floatValue", "double", "doubleValue", "boolean", "booleanValue", "char", "charValue");

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("auto.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            AutoUnboxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public LocalQuickFix buildFix(Object ... infos) {
        if (infos.length == 0 || !AutoUnboxingInspection.isFixApplicable((PsiExpression)infos[0])) {
            return null;
        }
        return new AutoUnboxingFix();
    }

    private static boolean isFixApplicable(PsiExpression location) {
        PsiReferenceExpression reference;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)location.getParent());
        if (!(parent instanceof PsiPostfixExpression)) {
            return true;
        }
        if (location instanceof PsiReferenceExpression) {
            reference = (PsiReferenceExpression)location;
        } else if (location instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)location;
            PsiExpression expression = arrayAccessExpression.getArrayExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return true;
            }
            reference = (PsiReferenceExpression)expression;
        } else {
            return true;
        }
        PsiElement element = reference.resolve();
        if (element == null) {
            return true;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class);
        assert (statement != null);
        LocalSearchScope scope = new LocalSearchScope((PsiElement)statement);
        Query query = ReferencesSearch.search((PsiElement)element, (SearchScope)scope);
        Collection references = query.findAll();
        return references.size() <= 1;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            AutoUnboxingInspection.$$$reportNull$$$0(1);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AutoUnboxingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/jdk/AutoUnboxingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/jdk/AutoUnboxingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class AutoUnboxingFix
    extends PsiUpdateModCommandQuickFix {
        private AutoUnboxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.unboxing.make.unboxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                AutoUnboxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            PsiType type;
            if (project == null) {
                AutoUnboxingFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AutoUnboxingFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AutoUnboxingFix.$$$reportNull$$$0(3);
            }
            if ((type = (expression = (PsiExpression)startElement).getType()) == null) {
                return;
            }
            PsiPrimitiveType unboxedType = (PsiPrimitiveType)ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (unboxedType == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String newExpressionText = AutoUnboxingFix.buildNewExpressionText(expression, unboxedType, commentTracker);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiElement parent = expression.getParent();
            String expressionText = expression.getText();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, newExpressionText, commentTracker);
                return;
            }
            if (parent instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
                if (!unboxedType.equalsToText("boolean")) {
                    IElementType tokenType = prefixExpression.getOperationTokenType();
                    if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                        commentTracker.markUnchanged(expression);
                        PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, expressionText + "=" + newExpressionText + "+1", commentTracker);
                        return;
                    }
                    if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
                        commentTracker.markUnchanged(expression);
                        PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, expressionText + "=" + newExpressionText + "-1", commentTracker);
                        return;
                    }
                    PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, prefixExpression.getOperationSign().getText() + newExpressionText, commentTracker);
                    return;
                }
            }
            if (parent instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parent;
                IElementType tokenType = postfixExpression.getOperationTokenType();
                PsiElement grandParent = postfixExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                        commentTracker.markUnchanged(expression);
                        PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, expressionText + "=" + newExpressionText + "+1", commentTracker);
                        return;
                    }
                    if (!JavaTokenType.MINUSMINUS.equals(tokenType)) return;
                    commentTracker.markUnchanged(expression);
                    PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, expressionText + "=" + newExpressionText + "-1", commentTracker);
                    return;
                }
                PsiElement element = postfixExpression.replace((PsiElement)postfixExpression.getOperand());
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
                if (statement == null) {
                    return;
                }
                PsiStatement newStatement = JavaTokenType.PLUSPLUS.equals(tokenType) ? factory.createStatementFromText(expressionText + "=" + newExpressionText + "+1;", (PsiElement)statement) : factory.createStatementFromText(expressionText + "=" + newExpressionText + "-1;", (PsiElement)statement);
                PsiElement greatGrandParent = statement.getParent();
                greatGrandParent.addAfter((PsiElement)newStatement, (PsiElement)statement);
                return;
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                PsiReplacementUtil.replaceExpression(expression, newExpressionText, commentTracker);
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (!expression.equals((Object)lExpression)) {
                PsiReplacementUtil.replaceExpression(expression, newExpressionText, commentTracker);
                return;
            }
            PsiJavaToken operationSign = assignmentExpression.getOperationSign();
            String operationSignText = operationSign.getText();
            char sign = operationSignText.charAt(0);
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (rExpression == null) {
                return;
            }
            String text = commentTracker.text((PsiElement)lExpression) + "=" + newExpressionText + sign + commentTracker.text((PsiElement)rExpression);
            PsiExpression newExpression = factory.createExpressionFromText(text, (PsiElement)assignmentExpression);
            commentTracker.replaceAndRestoreComments((PsiElement)assignmentExpression, (PsiElement)newExpression);
        }

        private static String buildNewExpressionText(PsiExpression expression, PsiPrimitiveType unboxedType, CommentTracker commentTracker) {
            PsiMethodCallExpression methodCallExpression;
            String constantText = AutoUnboxingFix.computeConstantBooleanText(expression);
            if (constantText != null) {
                return constantText;
            }
            String expressionText = AutoUnboxingFix.getExpressionText(expression, new StringBuilder()).toString();
            String boxMethodName = s_unboxingMethods.get(unboxedType.getCanonicalText());
            if (expression instanceof PsiMethodCallExpression && AutoUnboxingFix.isValueOfCall(methodCallExpression = (PsiMethodCallExpression)expression)) {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiExpression argument = commentTracker.markUnchanged(arguments[0]);
                return argument.getText();
            }
            commentTracker.markUnchanged(expression);
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.Object")) {
                return "((" + unboxedType.getBoxedTypeName() + ")" + expressionText + ")." + boxMethodName + "()";
            }
            return PsiPrecedenceUtil.getPrecedence((PsiExpression)expression) > 1 ? "(" + expressionText + ")." + boxMethodName + "()" : expressionText + "." + boxMethodName + "()";
        }

        private static StringBuilder getExpressionText(PsiExpression expression, StringBuilder out) {
            if (expression instanceof PsiMethodCallExpression) {
                PsiExpression explicitExpression = AddTypeArgumentsFix.addTypeArguments(expression, null);
                if (explicitExpression != null) {
                    out.append(explicitExpression.getText());
                } else {
                    out.append(expression.getText());
                }
            } else if (expression instanceof PsiParenthesizedExpression) {
                out.append('(');
                PsiExpression expression1 = ((PsiParenthesizedExpression)expression).getExpression();
                if (expression1 != null) {
                    AutoUnboxingFix.getExpressionText(expression1, out);
                }
                out.append(')');
            } else if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
                out.append(conditional.getCondition().getText()).append('?');
                AutoUnboxingFix.getExpressionText(conditional.getThenExpression(), out);
                out.append(':');
                AutoUnboxingFix.getExpressionText(conditional.getElseExpression(), out);
            } else {
                out.append(expression.getText());
            }
            return out;
        }

        private static boolean isValueOfCall(PsiMethodCallExpression methodCallExpression) {
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            return MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", null, "valueOf", new PsiType[]{PsiTypes.intType()}) && PsiTypes.intType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", null, "valueOf", new PsiType[]{PsiTypes.shortType()}) && PsiTypes.shortType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", null, "valueOf", new PsiType[]{PsiTypes.byteType()}) && PsiTypes.byteType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", null, "valueOf", new PsiType[]{PsiTypes.longType()}) && PsiTypes.longType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", null, "valueOf", new PsiType[]{PsiTypes.charType()}) && PsiTypes.charType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", null, "valueOf", new PsiType[]{PsiTypes.doubleType()}) && PsiTypes.doubleType().equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", null, "valueOf", new PsiType[]{PsiTypes.floatType()}) && PsiTypes.floatType().equals((Object)type);
        }

        @NonNls
        private static String computeConstantBooleanText(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            Boolean bool = BoolUtils.fromBoxedConstantReference((PsiExpression)referenceExpression);
            if (bool == null) {
                return null;
            }
            return bool.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AutoUnboxingVisitor
    extends BaseInspectionVisitor {
        private AutoUnboxingVisitor() {
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(1);
            }
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(2);
            }
            super.visitReferenceExpression(expression);
            if (expression instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression;
                if (methodReferenceExpression.isConstructor()) {
                    return;
                }
                PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                PsiElement target = methodReferenceExpression.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)returnType)) {
                    return;
                }
                PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)returnType);
                if (unboxedType == null) {
                    return;
                }
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodReferenceExpression);
                if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)functionalInterfaceReturnType) || !functionalInterfaceReturnType.isAssignableFrom((PsiType)unboxedType)) {
                    return;
                }
                this.registerError(referenceNameElement, new Object[0]);
            } else {
                this.checkExpression((PsiExpression)expression);
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(3);
            }
            super.visitNewExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(4);
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
                return;
            }
            this.checkExpression((PsiExpression)expression);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(5);
            }
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(6);
            }
            super.visitSwitchExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                AutoUnboxingVisitor.$$$reportNull$$$0(7);
            }
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            PsiPrimitiveType unboxedType;
            PsiType expressionType = expression.getType();
            if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expressionType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType)) {
                return;
            }
            if (!(PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent()) instanceof PsiTypeCastExpression || (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)expressionType)) != null && expectedType.isAssignableFrom((PsiType)unboxedType))) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

