/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ForeachStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ForeachStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ForEachFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/ForeachStatementInspection", "buildErrorString"));
    }

    private static class ForEachFix
    extends PsiUpdateModCommandQuickFix {
        private ForEachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
            if (string == null) {
                ForEachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ForEachFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ForEachFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ForEachFix.$$$reportNull$$$0(3);
            }
            PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
            assert (statement != null);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            @NonNls StringBuilder newStatement = new StringBuilder();
            PsiParameter iterationParameter = statement.getIterationParameter();
            boolean generateFinalLocals = JavaFileCodeStyleFacade.forContext((PsiFile)element.getContainingFile()).isGenerateFinalLocals();
            tracker.markUnchanged(iteratedValue);
            if (iteratedValue.getType() instanceof PsiArrayType) {
                PsiType type = iterationParameter.getType();
                String index = new VariableNameGenerator((PsiElement)statement, VariableKind.LOCAL_VARIABLE).byType((PsiType)PsiTypes.intType()).byName("i", "j", "k").generate(true);
                newStatement.append("for(int ").append(index).append(" = 0;");
                newStatement.append(index).append('<').append(iteratedValue.getText()).append(".length;");
                newStatement.append(index).append("++)").append("{ ");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(type.getCanonicalText()).append(' ').append(iterationParameter.getName());
                newStatement.append(" = ").append(iteratedValue.getText()).append('[').append(index).append("];");
            } else {
                @NonNls StringBuilder methodCall = new StringBuilder();
                if (ParenthesesUtils.getPrecedence(iteratedValue) > 1) {
                    methodCall.append('(').append(iteratedValue.getText()).append(')');
                } else {
                    methodCall.append(iteratedValue.getText());
                }
                methodCall.append(".iterator()");
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue);
                PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
                if (variableType == null) {
                    return;
                }
                PsiType parameterType = iterationParameter.getType();
                String typeText = parameterType.getCanonicalText();
                newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
                String iterator = new VariableNameGenerator((PsiElement)statement, VariableKind.LOCAL_VARIABLE).byName("iterator", "iter", "itr").generate(true);
                newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
                newStatement.append(iterator).append(".hasNext();){");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
            }
            PsiStatement body = statement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children = block.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    newStatement.append(tracker.text(children[i]));
                }
            } else {
                String bodyText = body == null ? "" : tracker.text((PsiElement)body);
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement.toString(), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/jdk/ForeachStatementInspection$ForEachFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/jdk/ForeachStatementInspection$ForEachFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                ForeachStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null || !InheritanceUtil.isInheritor((PsiType)iteratedValue.getType(), (String)"java.lang.Iterable")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/jdk/ForeachStatementInspection$ForeachStatementVisitor", "visitForeachStatement"));
        }
    }
}

