/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NotNull;

public class ReplaceEmptyArrayToConstantFix
extends PsiUpdateModCommandQuickFix {
    private final String myText;
    @IntentionName
    private final String myName;

    public ReplaceEmptyArrayToConstantFix(PsiClass aClass, PsiField field) {
        this.myText = aClass.getQualifiedName() + "." + field.getName();
        this.myName = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{aClass.getName() + "." + field.getName()});
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.quickfix.family", new Object[0]);
        if (string == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            ReplaceEmptyArrayToConstantFix.$$$reportNull$$$0(4);
        }
        PsiExpression newExp = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(this.myText, startElement);
        PsiElement element = startElement.replace((PsiElement)newExp);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/memory/ReplaceEmptyArrayToConstantFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/memory/ReplaceEmptyArrayToConstantFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

