/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class ReturnOfInnerClassInspection
extends BaseInspection {
    public boolean ignoreNonPublic = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = switch (((ClassType)((Object)infos[0])).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> InspectionGadgetsBundle.message("return.of.anonymous.class.problem.descriptor", new Object[0]);
            case 1 -> InspectionGadgetsBundle.message("return.of.local.class.problem.descriptor", ((PsiClass)infos[1]).getName());
            case 2 -> InspectionGadgetsBundle.message("return.of.inner.class.problem.descriptor", ((PsiClass)infos[1]).getName());
        };
        if (string == null) {
            ReturnOfInnerClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonPublic", (String)InspectionGadgetsBundle.message("return.of.inner.class.ignore.non.public.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ReturnOfInnerClassInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/ReturnOfInnerClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum ClassType {
        ANONYMOUS_CLASS,
        LOCAL_CLASS,
        INNER_CLASS;

    }

    private class ReturnOfInnerClassVisitor
    extends BaseInspectionVisitor {
        private ReturnOfInnerClassVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            if (statement == null) {
                ReturnOfInnerClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getReturnValue());
            if (expression == null) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method == null || method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            if (ReturnOfInnerClassInspection.this.ignoreNonPublic && (method.hasModifierProperty("protected") || method.hasModifierProperty("packageLocal"))) {
                return;
            }
            if (expression instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)expression).getAnonymousClass()) != null) {
                this.registerStatementError((PsiStatement)statement, new Object[]{ClassType.ANONYMOUS_CLASS});
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getType());
            if (aClass == null) {
                return;
            }
            if (PsiUtil.isLocalClass((PsiClass)aClass)) {
                this.registerStatementError((PsiStatement)statement, new Object[]{ClassType.LOCAL_CLASS, aClass});
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null || aClass.hasModifierProperty("static")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[]{ClassType.INNER_CLASS, aClass});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/memory/ReturnOfInnerClassInspection$ReturnOfInnerClassVisitor", "visitReturnStatement"));
        }
    }
}

