/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public final class StaticCollectionInspection
extends BaseInspection {
    public boolean m_ignoreWeakCollections = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.collection.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticCollectionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreWeakCollections", (String)InspectionGadgetsBundle.message("static.collection.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StaticCollectionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticCollectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/StaticCollectionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticCollectionVisitor
    extends BaseInspectionVisitor {
        private StaticCollectionVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiExpression method;
            PsiMethodCallExpression call;
            PsiExpression psiExpression;
            if (field == null) {
                StaticCollectionVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiType type = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return;
            }
            if (StaticCollectionInspection.this.m_ignoreWeakCollections && CollectionUtils.isWeakCollectionClass(type)) {
                return;
            }
            if (field.hasModifierProperty("final") && (psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)field.getInitializer())) instanceof PsiMethodCallExpression && (psiExpression = (call = (PsiMethodCallExpression)psiExpression).resolveMethod()) instanceof PsiMethod && Mutability.getMutability((PsiModifierListOwner)(method = psiExpression)).isUnmodifiable()) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/memory/StaticCollectionInspection$StaticCollectionVisitor", "visitField"));
        }
    }
}

