/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.memory.ReplaceEmptyArrayToConstantFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryEmptyArrayUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryEmptyArrayUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceEmptyArrayToConstantFix((PsiClass)infos[0], (PsiField)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiType arrayType;
                PsiClass typeClass;
                PsiType type;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ConstructionUtils.isEmptyArrayInitializer((PsiExpression)expression) && (type = expression.getType()) instanceof PsiArrayType && (typeClass = PsiTypesUtil.getPsiClass((PsiType)(arrayType = ((PsiArrayType)type).getComponentType()))) != null) {
                    for (PsiField field : typeClass.getFields()) {
                        PsiModifierList modifiers = field.getModifierList();
                        if (modifiers == null || typeClass.isEquivalentTo(PsiTreeUtil.findFirstParent((PsiElement)expression, e -> e instanceof PsiClass)) || !modifiers.hasModifierProperty("public") || !field.getType().equals(type) || !CollectionUtils.isConstantEmptyArray(field)) continue;
                        this.registerError((PsiElement)expression, typeClass, field);
                        return;
                    }
                }
                super.visitNewExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/memory/UnnecessaryEmptyArrayUsageInspection$1", "visitNewExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/UnnecessaryEmptyArrayUsageInspection", "buildErrorString"));
    }
}

