/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.CouplingVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public final class MethodCouplingInspection
extends MethodMetricInspection {
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @NotNull
    public String getID() {
        return "OverlyCoupledMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer coupling = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.coupling.problem.descriptor", coupling);
        if (string == null) {
            MethodCouplingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.coupling.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)this.getConfigurationLabel(), (int)1, (int)1000), OptPane.checkbox((String)"m_includeJavaClasses", (String)InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_includeLibraryClasses", (String)InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MethodCouplingInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCouplingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/MethodCouplingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCouplingVisitor
    extends BaseInspectionVisitor {
        private MethodCouplingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodCouplingVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CouplingVisitor visitor2 = new CouplingVisitor(method, MethodCouplingInspection.this.m_includeJavaClasses, MethodCouplingInspection.this.m_includeLibraryClasses);
            method.accept((PsiElementVisitor)visitor2);
            int coupling = visitor2.getNumDependencies();
            if (coupling <= MethodCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, coupling);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MethodCouplingInspection$MethodCouplingVisitor", "visitMethod"));
        }
    }
}

