/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.ReturnPointCountVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class MultipleReturnPointsPerMethodInspection
extends MethodMetricInspection {
    public boolean ignoreGuardClauses = false;
    public boolean ignoreEqualsMethod = false;

    @NotNull
    public String getID() {
        return "MethodWithMultipleReturnPoints";
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.problem.descriptor", returnPointCount);
        if (string == null) {
            MultipleReturnPointsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]), (int)1, (int)100), OptPane.checkbox((String)"ignoreGuardClauses", (String)InspectionGadgetsBundle.message("ignore.guard.clauses.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreEqualsMethod", (String)InspectionGadgetsBundle.message("ignore.for.equals.methods.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MultipleReturnPointsPerMethodInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MultipleReturnPointsPerMethodVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MultipleReturnPointsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (MultipleReturnPointsPerMethodInspection.this.ignoreEqualsMethod && MethodUtils.isEquals(method)) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= MultipleReturnPointsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(PsiMethod method) {
            ReturnPointCountVisitor visitor2 = new ReturnPointCountVisitor(MultipleReturnPointsPerMethodInspection.this.ignoreGuardClauses);
            method.accept((PsiElementVisitor)visitor2);
            int count = visitor2.getCount();
            if (!MultipleReturnPointsPerMethodVisitor.mayFallThroughBottom(method)) {
                return count;
            }
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private static boolean mayFallThroughBottom(PsiMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiTypes.voidType().equals((Object)returnType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection$MultipleReturnPointsPerMethodVisitor", "visitMethod"));
        }
    }
}

