/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final int myLimit;
    private int m_maximumDepth;
    private int m_currentDepth;
    private final Set<PsiElement> scopeEntered = new HashSet<PsiElement>();

    NestingDepthVisitor(int limit) {
        this.myLimit = limit;
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            NestingDepthVisitor.$$$reportNull$$$0(0);
        }
    }

    public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
        PsiElement parent;
        boolean isAlreadyCounted;
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(1);
        }
        boolean bl = isAlreadyCounted = (parent = statement.getParent()) instanceof PsiDoWhileStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiForeachStatement || parent instanceof PsiIfStatement || parent instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitBlockStatement(statement);
    }

    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        if (expression == null) {
            NestingDepthVisitor.$$$reportNull$$$0(2);
        }
        if (expression.getBody() instanceof PsiCodeBlock) {
            this.enterScope((PsiElement)expression);
        }
        super.visitLambdaExpression(expression);
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(3);
        }
        this.enterScope((PsiElement)statement);
        super.visitDoWhileStatement(statement);
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(4);
        }
        this.enterScope((PsiElement)statement);
        super.visitForStatement(statement);
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(5);
        }
        this.enterScope((PsiElement)statement);
        super.visitForeachStatement(statement);
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        PsiStatement elseBranch;
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(6);
        }
        boolean isAlreadyCounted = false;
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement && statement.equals((Object)(elseBranch = ((PsiIfStatement)parent).getElseBranch()))) {
            isAlreadyCounted = true;
        }
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitIfStatement(statement);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(7);
        }
        this.enterScope((PsiElement)statement);
        super.visitSynchronizedStatement(statement);
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(8);
        }
        this.enterScope((PsiElement)statement);
        super.visitTryStatement(statement);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(9);
        }
        this.enterScope((PsiElement)statement);
        super.visitSwitchStatement(statement);
    }

    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        if (expression == null) {
            NestingDepthVisitor.$$$reportNull$$$0(10);
        }
        this.enterScope((PsiElement)expression);
        super.visitSwitchExpression(expression);
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            NestingDepthVisitor.$$$reportNull$$$0(11);
        }
        this.enterScope((PsiElement)statement);
        super.visitWhileStatement(statement);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            NestingDepthVisitor.$$$reportNull$$$0(12);
        }
        this.exitScope(element);
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
        if (this.m_maximumDepth > this.myLimit) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.m_currentDepth;
        }
    }

    int getMaximumDepth() {
        return this.m_maximumDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/methodmetrics/NestingDepthVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnonymousClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlockStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLambdaExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhileStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSynchronizedStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

