/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.NegationCountVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class ThreeNegationsPerMethodInspection
extends BaseInspection {
    public boolean m_ignoreInEquals = true;
    public boolean ignoreInAssert = false;

    @NotNull
    public String getID() {
        return "MethodWithMoreThanThreeNegations";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreInEquals", (String)InspectionGadgetsBundle.message("three.negations.per.method.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreInAssert", (String)InspectionGadgetsBundle.message("three.negations.per.method.ignore.assert.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ThreeNegationsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("three.negations.per.method.problem.descriptor", negationCount);
        if (string == null) {
            ThreeNegationsPerMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThreeNegationsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ThreeNegationsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThreeNegationsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ThreeNegationsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NegationCountVisitor visitor2 = new NegationCountVisitor(ThreeNegationsPerMethodInspection.this.ignoreInAssert);
            method.accept((PsiElementVisitor)visitor2);
            int negationCount = visitor2.getCount();
            if (negationCount <= 3) {
                return;
            }
            if (ThreeNegationsPerMethodInspection.this.m_ignoreInEquals && MethodUtils.isEquals(method)) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection$ThreeNegationsPerMethodVisitor", "visitMethod"));
        }
    }
}

