/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public final class ThrownExceptionsPerMethodInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "MethodWithTooExceptionsDeclared";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer exceptionCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("thrown.exceptions.per.method.problem.descriptor", exceptionCount);
        if (string == null) {
            ThrownExceptionsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("thrown.exceptions.per.method.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThrownExceptionsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ThrownExceptionsPerMethodInspection", "buildErrorString"));
    }

    private class ThrownExceptionsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThrownExceptionsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ThrownExceptionsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiReferenceList throwList = method.getThrowsList();
            PsiJavaCodeReferenceElement[] thrownExceptions = throwList.getReferenceElements();
            int exceptionCount = thrownExceptions.length;
            if (exceptionCount <= ThrownExceptionsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, exceptionCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ThrownExceptionsPerMethodInspection$ThrownExceptionsPerMethodVisitor", "visitMethod"));
        }
    }
}

