/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexOfReplaceableByContainsInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String text;
        PsiBinaryExpression expression = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
        if (lhs instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            text = IndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression.getOperationTokenType(), new CommentTracker());
        } else {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
            assert (callExpression != null);
            text = IndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression.getOperationTokenType(), new CommentTracker());
        }
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", text);
        if (string == null) {
            IndexOfReplaceableByContainsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new IndexOfReplaceableByContainsFix();
    }

    static String createContainsExpressionText(@NotNull PsiMethodCallExpression call, boolean flipped, IElementType tokenType, CommentTracker commentTracker) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (call == null) {
            IndexOfReplaceableByContainsInspection.$$$reportNull$$$0(1);
        }
        String qualifierText = (qualifierExpression = (methodExpression = call.getMethodExpression()).getQualifierExpression()) == null ? "" : commentTracker.text((PsiElement)qualifierExpression);
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression expression = argumentList.getExpressions()[0];
        @NonNls String newExpressionText = qualifierText + ".contains(" + commentTracker.text((PsiElement)expression) + ")";
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return "!" + newExpressionText;
        }
        if (!flipped && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE))) {
            return "!" + newExpressionText;
        }
        if (flipped && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE))) {
            return "!" + newExpressionText;
        }
        return newExpressionText;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            IndexOfReplaceableByContainsInspection.$$$reportNull$$$0(2);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/IndexOfReplaceableByContainsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/IndexOfReplaceableByContainsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createContainsExpressionText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class IndexOfReplaceableByContainsFix
    extends PsiUpdateModCommandQuickFix {
        private IndexOfReplaceableByContainsFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            String newExpressionText;
            if (project == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(2);
            }
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression expression = (PsiBinaryExpression)element;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
            CommentTracker commentTracker = new CommentTracker();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
                newExpressionText = IndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression.getOperationTokenType(), commentTracker);
            } else if (rhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)rhs;
                newExpressionText = IndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression.getOperationTokenType(), commentTracker);
            } else {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpressionText, commentTracker);
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"indexOf()", "contains()"});
            if (string == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/IndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/IndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends BaseInspectionVisitor {
        private IndexOfReplaceableByContainsVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                IndexOfReplaceableByContainsVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
            if (rhs == null || lhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            if (lhs instanceof PsiMethodCallExpression) {
                if (IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(lhs, rhs, false, expression.getOperationTokenType())) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (rhs instanceof PsiMethodCallExpression && IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(rhs, lhs, true, expression.getOperationTokenType())) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean canBeReplacedByContains(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!IndexOfReplaceableByContainsVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (flipped) {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.LT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.GE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType))) {
                    return true;
                }
            } else {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.LE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.GE.equals(tokenType) || JavaTokenType.LT.equals(tokenType))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression;
            String methodName;
            if (expression == null) {
                IndexOfReplaceableByContainsVisitor.$$$reportNull$$$0(1);
            }
            if (!"indexOf".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiType argumentType = arguments[0].getType();
            if (argumentType == null || !argumentType.equalsToText("java.lang.String")) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            return qualifierType != null && qualifierType.equalsToText("java.lang.String");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/migration/IndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIndexOfCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

