/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MethodCanBeVariableArityMethodInspection
extends BaseInspection {
    public boolean ignoreByteAndShortArrayParameters = false;
    public boolean ignoreAllPrimitiveArrayParameters = false;
    public boolean ignoreOverridingMethods = false;
    public boolean onlyReportPublicMethods = false;
    public boolean ignoreMultipleArrayParameters = false;
    public boolean ignoreMultiDimensionalArrayParameters = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.can.be.variable.arity.method.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodCanBeVariableArityMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreByteAndShortArrayParameters", (String)InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.byte.short.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAllPrimitiveArrayParameters", (String)InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.all.primitive.arrays.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])}), OptPane.checkbox((String)"ignoreOverridingMethods", (String)InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"onlyReportPublicMethods", (String)InspectionGadgetsBundle.message("only.report.public.methods.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreMultipleArrayParameters", (String)InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.multiple.arrays.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreMultiDimensionalArrayParameters", (String)InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.multidimensional.arrays.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MethodCanBeVariableArityMethodInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ConvertToVarargsMethodFix();
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.VARARGS);
        if (set == null) {
            MethodCanBeVariableArityMethodInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeVariableArityMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCanBeVariableArityMethodVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeVariableArityMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiArrayType arrayType;
            PsiParameter lastParameter;
            PsiParameter[] parameters;
            block19: {
                block18: {
                    if (method == null) {
                        MethodCanBeVariableArityMethodVisitor.$$$reportNull$$$0(0);
                    }
                    super.visitMethod(method);
                    if (MethodCanBeVariableArityMethodInspection.this.onlyReportPublicMethods && !method.hasModifierProperty("public")) {
                        return;
                    }
                    if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)method)) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    parameters = parameterList.getParameters();
                    if (parameters.length == 0) {
                        return;
                    }
                    lastParameter = parameters[parameters.length - 1];
                    PsiType type = lastParameter.getType();
                    if (!(type instanceof PsiArrayType)) break block18;
                    arrayType = (PsiArrayType)type;
                    if (!(type instanceof PsiEllipsisType)) break block19;
                }
                return;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)lastParameter)) {
                return;
            }
            PsiType componentType = arrayType.getComponentType();
            if (MethodCanBeVariableArityMethodInspection.this.ignoreMultiDimensionalArrayParameters && componentType instanceof PsiArrayType) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreByteAndShortArrayParameters) {
                if (PsiTypes.byteType().equals((Object)componentType) || PsiTypes.shortType().equals((Object)componentType)) {
                    return;
                }
                if (MethodCanBeVariableArityMethodInspection.this.ignoreAllPrimitiveArrayParameters && componentType instanceof PsiPrimitiveType) {
                    return;
                }
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreMultipleArrayParameters) {
                int length = parameters.length - 1;
                for (int i = 0; i < length; ++i) {
                    PsiParameter parameter = parameters[i];
                    if (!(parameter.getType() instanceof PsiArrayType)) continue;
                    return;
                }
            }
            if (this.isVisibleHighlight((PsiElement)method)) {
                this.registerMethodError(method, new Object[0]);
            } else {
                this.registerErrorAtRange(method.getFirstChild(), (PsiElement)method.getParameterList(), new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection$MethodCanBeVariableArityMethodVisitor", "visitMethod"));
        }
    }
}

