/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringBufferReplaceableByStringBuilderInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getID() {
        return "StringBufferMayBeStringBuilder";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.problem.descriptor", new Object[0]);
        if (string == null) {
            StringBufferReplaceableByStringBuilderInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new StringBufferMayBeStringBuilderFix();
    }

    @Nullable
    private static PsiExpression getNewStringBuffer(PsiExpression expression) {
        PsiReferenceExpression methodExpression;
        String methodName;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return null;
        }
        if (expression instanceof PsiNewExpression || ExpressionUtils.isNullLiteral(expression)) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression && ("append".equals(methodName = (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getReferenceName()) || "appendCodePoint".equals(methodName) || "insert".equals(methodName))) {
            return StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(methodExpression.getQualifierExpression());
        }
        return null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringBuilderVisitor();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            StringBufferReplaceableByStringBuilderInspection.$$$reportNull$$$0(1);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class StringBufferMayBeStringBuilderFix
    extends PsiUpdateModCommandQuickFix {
        private StringBufferMayBeStringBuilderFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"StringBuilder"});
            if (string == null) {
                StringBufferMayBeStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement[] declaredElements;
            if (project == null) {
                StringBufferMayBeStringBuilderFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                StringBufferMayBeStringBuilderFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                StringBufferMayBeStringBuilderFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = element.getParent();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass stringBuilderClass = psiFacade.findClass("java.lang.StringBuilder", element.getResolveScope());
            if (stringBuilderClass == null) {
                return;
            }
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiJavaCodeReferenceElement stringBuilderClassReference = factory.createClassReferenceElement(stringBuilderClass);
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                if (!(declaredElement instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)declaredElement;
                StringBufferMayBeStringBuilderFix.replaceWithStringBuilder(stringBuilderClassReference, variable);
                StringBufferMayBeStringBuilderFix.replaceAssignmentsWithStringBuilder(variable, stringBuilderClassReference);
            }
        }

        private static void replaceAssignmentsWithStringBuilder(PsiVariable variable, PsiJavaCodeReferenceElement stringBuilderClassReference) {
            List<PsiReferenceExpression> references = VariableAccessUtils.getVariableReferences(variable);
            for (PsiReference psiReference : references) {
                PsiJavaCodeReferenceElement classReference;
                PsiAssignmentExpression assignmentExpression;
                PsiExpression rhs;
                PsiExpression newExpression;
                PsiElement referenceElement = PsiUtil.skipParenthesizedExprUp((PsiElement)psiReference.getElement().getParent());
                if (!(referenceElement instanceof PsiAssignmentExpression) || !((newExpression = StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(rhs = (assignmentExpression = (PsiAssignmentExpression)referenceElement).getRExpression())) instanceof PsiNewExpression) || (classReference = ((PsiNewExpression)newExpression).getClassReference()) == null) continue;
                classReference.replace((PsiElement)stringBuilderClassReference);
            }
        }

        private static void replaceWithStringBuilder(PsiJavaCodeReferenceElement newClassReference, PsiVariable variable) {
            PsiExpression newExpression;
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (!typeElement.isInferredType()) {
                PsiJavaCodeReferenceElement oldReferenceElement = typeElement.getInnermostComponentReferenceElement();
                if (oldReferenceElement == null) {
                    return;
                }
                oldReferenceElement.replace((PsiElement)newClassReference);
            }
            if (!((newExpression = StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(variable.getInitializer())) instanceof PsiNewExpression)) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)newExpression).getClassReference();
            if (classReference == null) {
                return;
            }
            classReference.replace((PsiElement)newClassReference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection$StringBufferMayBeStringBuilderFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection$StringBufferMayBeStringBuilderFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StringBufferReplaceableByStringBuilderVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> SAFE_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"java.lang.StringBuilder", "java.lang.StringBuffer", "java.lang.String"});

        private StringBufferReplaceableByStringBuilderVisitor() {
        }

        public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
            if (statement == null) {
                StringBufferReplaceableByStringBuilderVisitor.$$$reportNull$$$0(0);
            }
            super.visitDeclarationStatement(statement);
            PsiElement[] declaredElements = statement.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
                if (StringBufferReplaceableByStringBuilderVisitor.isReplaceableStringBuffer((PsiVariable)variable, context)) continue;
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)declaredElements[0];
            this.registerVariableError((PsiVariable)firstVariable, new Object[0]);
        }

        private static boolean isReplaceableStringBuffer(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type)) {
                return false;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(initializer) == null) {
                return false;
            }
            Predicate<PsiAssignmentExpression> skipFilter = e -> StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(e.getRExpression()) != null;
            if (VariableAccessUtils.variableIsAssigned(variable, skipFilter, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context, true)) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass(variable, context)) {
                return false;
            }
            Processor processor = call -> {
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String fqName = aClass.getQualifiedName();
                if ("java.util.regex.Matcher".equals(fqName)) {
                    if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)call)) {
                        return false;
                    }
                    String methodName = method.getName();
                    if ("appendTail".equals(methodName)) {
                        return call instanceof PsiExpression && StringBufferReplaceableByStringBuilderVisitor.isSafeStringBufferUsage((PsiExpression)call);
                    }
                    if ("appendReplacement".equals(methodName)) {
                        return true;
                    }
                }
                return SAFE_CLASSES.contains(fqName);
            };
            return !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, true, (Processor<? super PsiCall>)processor);
        }

        private static boolean isSafeStringBufferUsage(PsiExpression expression) {
            PsiElement grandParent;
            if (expression == null) {
                return false;
            }
            if (ExpressionUtils.isVoidContext(expression)) {
                return true;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiReferenceExpression && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression) {
                String methodName = ((PsiReferenceExpression)parent).getReferenceName();
                if ("toString".equals(methodName)) {
                    return true;
                }
                if ("append".equals(methodName) || "appendCodePoint".equals(methodName) || "insert".equals(methodName)) {
                    return StringBufferReplaceableByStringBuilderVisitor.isSafeStringBufferUsage((PsiExpression)grandParent);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection$StringBufferReplaceableByStringBuilderVisitor", "visitDeclarationStatement"));
        }
    }
}

