/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
        if (string == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TRY_WITH_RESOURCES);
        if (set == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    private static List<PsiStatement> collectStatementsBetween(PsiStatement startExclusive, PsiStatement endExclusive) {
        ArrayList<PsiStatement> statements = new ArrayList<PsiStatement>();
        PsiStatement current = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)startExclusive, PsiStatement.class);
        while (current != endExclusive && current != null) {
            statements.add(current);
            current = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)current.getNextSibling(), PsiStatement.class);
        }
        return statements;
    }

    private static boolean resourceVariablesUsedInFinally(@NotNull PsiCodeBlock finallyBlock, @NotNull Set<? extends PsiVariable> collectedVariables) {
        if (finallyBlock == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(2);
        }
        if (collectedVariables == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(3);
        }
        if (ContainerUtil.exists(collectedVariables, variable -> TryFinallyCanBeTryWithResourcesInspection.isAutoCloseableDeclaredInFinallyBlock(finallyBlock, variable))) {
            return true;
        }
        AutoCloseableVariableUsedVisitor visitor2 = new AutoCloseableVariableUsedVisitor(collectedVariables);
        finallyBlock.accept((PsiElementVisitor)visitor2);
        return visitor2.isVariableUsed();
    }

    private static boolean resourceVariableUsedInCatches(PsiTryStatement tryStatement, Set<? extends PsiVariable> collectedVariables) {
        for (PsiCatchSection catchSection : tryStatement.getCatchSections()) {
            for (PsiVariable psiVariable : collectedVariables) {
                if (!VariableAccessUtils.variableIsUsed(psiVariable, (PsiElement)catchSection)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVariableUsedInsideContext(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(5);
        }
        VariableUsedWithContextVisitor visitor2 = new VariableUsedWithContextVisitor(variable, null);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isVariableUsed();
    }

    private static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedWithContextVisitor visitor2 = new VariableUsedWithContextVisitor(variable, context);
        PsiElement declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept((PsiElementVisitor)visitor2);
        return visitor2.isVariableUsed();
    }

    private static boolean findAutoClosableVariableWithoutTry(@Nullable PsiStatement statement, @NotNull Set<? super PsiVariable> variables) {
        if (variables == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(6);
        }
        if (statement instanceof PsiIfStatement) {
            PsiVariable resourceVariable;
            PsiLocalVariable variable;
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (ifStatement.getElseBranch() != null) {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (PsiTypes.nullType().equals(rhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(lhs);
            } else if (PsiTypes.nullType().equals(lhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(rhs);
            } else {
                return false;
            }
            if (variable == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(ControlFlowUtils.getOnlyStatementInBlock(codeBlock));
            } else {
                return false;
            }
            if (variable.equals((Object)resourceVariable)) {
                variables.add((PsiVariable)resourceVariable);
                return true;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("close".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter) || target instanceof PsiResourceVariable) {
                    return false;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable(variable)) {
                    return false;
                }
                variables.add((PsiVariable)variable);
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isAutoCloseableDeclaredInFinallyBlock(@NotNull PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (block == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(8);
        }
        return variable instanceof PsiLocalVariable && PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)variable, (boolean)true);
    }

    @Nullable
    private static PsiVariable findAutoCloseableVariable(@Nullable PsiStatement statement) {
        HashSet variables = new HashSet(1);
        if (!TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement, variables, null)) {
            return null;
        }
        if (variables.isEmpty()) {
            return null;
        }
        return (PsiVariable)ContainerUtil.getFirstItem(variables);
    }

    private static boolean findAutoCloseableVariables(@Nullable PsiStatement statement, @NotNull Set<? super PsiVariable> variables, @Nullable List<? super PsiCatchSection> catchSectionsToMigrate) {
        if (variables == null) {
            TryFinallyCanBeTryWithResourcesInspection.$$$reportNull$$$0(9);
        }
        if (TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(statement, variables)) {
            return true;
        }
        if (statement instanceof PsiTryStatement) {
            PsiStatement[] tryStatements;
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            if (tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
                return true;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return true;
            }
            for (PsiStatement tryStmt : tryStatements = tryBlock.getStatements()) {
                if (TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(tryStmt, variables)) continue;
                return false;
            }
            if (catchSectionsToMigrate != null) {
                catchSectionsToMigrate.addAll(Arrays.asList(tryStatement.getCatchSections()));
            }
            return true;
        }
        return false;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType());
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AutoCloseable");
    }

    private static int findInitialization(PsiElement[] elements, PsiVariable variable) {
        int result = -1;
        int statementsLength = elements.length;
        for (int i = 0; i < statementsLength; ++i) {
            PsiElement element = elements[i];
            if (TryFinallyCanBeTryWithResourcesInspection.isAssignmentToVariable(element, variable)) {
                if (result >= 0) {
                    return -1;
                }
                result = i;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, element)) continue;
            return -1;
        }
        return result;
    }

    private static boolean isAssignmentToVariable(PsiElement element, PsiVariable variable) {
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element, PsiExpressionStatement.class);
        if (expressionStatement == null) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        if (assignmentExpression.getRExpression() == null) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(assignmentExpression.getLExpression(), variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedVariables";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resourceVariablesUsedInFinally";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVariableUsedInsideContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAutoClosableVariableWithoutTry";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoCloseableDeclaredInFinallyBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAutoCloseableVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends PsiUpdateModCommandQuickFix {
        private TryFinallyCanBeTryWithResourcesFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
            if (string == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static <T> Pair<List<T>, List<T>> partition(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
            SmartList list1 = new SmartList();
            SmartList list2 = new SmartList();
            for (T value : iterable) {
                if (predicate.test(value)) {
                    list1.add(value);
                    continue;
                }
                list2.add(value);
            }
            return new Pair((Object)list1, (Object)list2);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLocalVariable variable2;
            PsiStatement declaration;
            PsiElement[] children;
            PsiElement parent;
            if (project == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Context context = Context.from(tryStatement);
            if (context == null) {
                return;
            }
            Pair<List<ResourceVariable>, List<ResourceVariable>> partition = TryFinallyCanBeTryWithResourcesFix.partition(context.myResourceVariables, variable -> variable.getInitializedElement().getTextOffset() < tryStatement.getTextOffset());
            List before = (List)partition.first;
            List after = (List)partition.second;
            String resourceListBefore = TryFinallyCanBeTryWithResourcesFix.joinToString(before);
            String resourceListAfter = TryFinallyCanBeTryWithResourcesFix.joinToString(after);
            @NonNls StringBuilder sb = new StringBuilder("try(");
            PsiResourceList resourceListElement = tryStatement.getResourceList();
            boolean hasSemicolon = false;
            if (!before.isEmpty()) {
                sb.append(resourceListBefore);
                if (resourceListElement != null || !after.isEmpty()) {
                    sb.append(";");
                    hasSemicolon = true;
                }
            }
            if (resourceListElement != null && (children = resourceListElement.getChildren()).length > 2 && resourceListElement.getResourceVariablesCount() > 0) {
                for (int i = 1; i < children.length - 1; ++i) {
                    sb.append(children[i].getText());
                }
            }
            if (!after.isEmpty()) {
                if (!(before.isEmpty() && resourceListElement == null || hasSemicolon)) {
                    sb.append(";");
                }
                sb.append(resourceListAfter);
            }
            sb.append(")");
            List locals = ((StreamEx)StreamEx.of(context.myResourceVariables).map(resourceVariable -> resourceVariable.myVariable).select(PsiLocalVariable.class).sorted((Comparator)PsiElementOrderComparator.getInstance())).toList();
            if (locals.size() == 1 && (declaration = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)(variable2 = (PsiLocalVariable)locals.getFirst()), PsiStatement.class)) != null && declaration.getParent() == tryStatement.getParent()) {
                List<PsiStatement> statements = TryFinallyCanBeTryWithResourcesInspection.collectStatementsBetween(declaration, (PsiStatement)tryStatement);
                PsiJavaToken lBrace = tryBlock.getLBrace();
                if (lBrace != null) {
                    for (PsiStatement statement : statements.reversed()) {
                        tryBlock.addAfter((PsiElement)statement, (PsiElement)lBrace);
                        if (!statement.isValid()) continue;
                        statement.delete();
                    }
                }
            }
            TryFinallyCanBeTryWithResourcesFix.restoreStatementsBeforeLastVariableInTryResource(tryStatement, tryBlock, context);
            HashSet<PsiCatchSection> catchSectionSet = new HashSet<PsiCatchSection>(context.myCatchSectionsToAdd);
            for (PsiStatement statement : context.myStatementsToDelete) {
                if (!statement.isValid()) continue;
                TryFinallyCanBeTryWithResourcesFix.deleteStatement(statement, catchSectionSet);
            }
            for (ResourceVariable variable3 : context.myResourceVariables) {
                if (variable3.myUsedOutsideTry || !variable3.myVariable.isValid()) continue;
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable3.myVariable);
            }
            if (!context.myCatchSectionsToAdd.isEmpty() && tryStatement.getCatchSections().length != 0) {
                sb.append("{").append("try");
                if (!TryFinallyCanBeTryWithResourcesFix.addTryAndCatchBlocks(tryStatement, sb)) {
                    return;
                }
                sb.append("}");
            } else if (!TryFinallyCanBeTryWithResourcesFix.addTryAndCatchBlocks(tryStatement, sb)) {
                return;
            }
            for (PsiCatchSection section : context.myCatchSectionsToAdd) {
                sb.append(section.getText());
            }
            if (!TryFinallyCanBeTryWithResourcesFix.addFinallyBlock(tryStatement, sb)) {
                return;
            }
            tryStatement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(sb.toString(), (PsiElement)tryStatement));
        }

        private static boolean addTryAndCatchBlocks(@NotNull PsiTryStatement tryStatement, @NotNull StringBuilder sb) {
            PsiCodeBlock tryBlock;
            if (tryStatement == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(4);
            }
            if (sb == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(5);
            }
            if ((tryBlock = tryStatement.getTryBlock()) == null) {
                return false;
            }
            sb.append(tryBlock.getText());
            for (PsiCatchSection section : tryStatement.getCatchSections()) {
                sb.append(section.getText());
            }
            return true;
        }

        private static boolean addFinallyBlock(@NotNull PsiTryStatement tryStatement, @NotNull StringBuilder sb) {
            PsiCodeBlock finallyBlock;
            if (tryStatement == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(6);
            }
            if (sb == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(7);
            }
            if ((finallyBlock = tryStatement.getFinallyBlock()) == null) {
                return false;
            }
            if (!ControlFlowUtils.isEmptyCodeBlock(finallyBlock)) {
                sb.append("finally").append(finallyBlock.getText());
            } else {
                Object[] finallyBlockChildren = finallyBlock.getChildren();
                if (!((StreamEx)((StreamEx)StreamEx.of((Object[])finallyBlockChildren).skip(1L)).limit((long)(finallyBlockChildren.length - 2))).allMatch(el -> el instanceof PsiWhiteSpace)) {
                    PsiElement tryParent = tryStatement.getParent();
                    tryParent.addRangeAfter((PsiElement)finallyBlockChildren[1], (PsiElement)finallyBlockChildren[finallyBlockChildren.length - 2], (PsiElement)tryStatement);
                }
            }
            return true;
        }

        private static void deleteStatement(@NotNull PsiStatement statement, @NotNull Set<PsiCatchSection> catchSectionSet) {
            if (statement == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(8);
            }
            if (catchSectionSet == null) {
                TryFinallyCanBeTryWithResourcesFix.$$$reportNull$$$0(9);
            }
            CommentTracker ct = new CommentTracker();
            if (statement instanceof PsiTryStatement) {
                PsiTryStatement psiTryStatement = (PsiTryStatement)statement;
                for (PsiCatchSection section : psiTryStatement.getCatchSections()) {
                    if (!catchSectionSet.contains(section)) continue;
                    ct.markUnchanged(section);
                }
            }
            ct.deleteAndRestoreComments((PsiElement)statement);
        }

        private static String joinToString(List<? extends ResourceVariable> variables) {
            return variables.stream().map(ResourceVariable::generateResourceDeclaration).collect(Collectors.joining("; "));
        }

        private static void restoreStatementsBeforeLastVariableInTryResource(PsiTryStatement tryStatement, PsiCodeBlock tryBlock, Context context) {
            Optional lastInTryVariable = ((StreamEx)StreamEx.of(context.myResourceVariables).map(v -> v.myInitializer).filter(e -> e != null && PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)e, (boolean)false))).max((Comparator)PsiElementOrderComparator.getInstance());
            ArrayList<PsiStatement> elementsToRestore = new ArrayList<PsiStatement>();
            if (lastInTryVariable.isPresent()) {
                PsiStatement last = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)lastInTryVariable.get()), PsiStatement.class);
                PsiStatement[] statements = tryBlock.getStatements();
                for (int i = 0; i < statements.length && statements[i] != last; ++i) {
                    PsiStatement current = statements[i];
                    if (context.myStatementsToDelete.contains(current)) continue;
                    elementsToRestore.add(current);
                }
            }
            PsiElement tryStatementParent = tryStatement.getParent();
            for (PsiStatement statement : elementsToRestore) {
                tryStatementParent.addBefore((PsiElement)statement, (PsiElement)tryStatement);
                statement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryStatement";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchSectionSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addTryAndCatchBlocks";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addFinallyBlock";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement tryStatement) {
            if (tryStatement == null) {
                TryFinallyCanBeTryWithResourcesVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(tryStatement);
            if (Context.from(tryStatement) == null) {
                return;
            }
            this.registerStatementError((PsiStatement)tryStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesVisitor", "visitTryStatement"));
        }
    }

    private static class AutoCloseableVariableUsedVisitor
    extends VariableUsedVisitorBase {
        @NotNull
        private final Set<? extends PsiVariable> collectedVariables;

        private AutoCloseableVariableUsedVisitor(@NotNull Set<? extends PsiVariable> collectedVariables) {
            if (collectedVariables == null) {
                AutoCloseableVariableUsedVisitor.$$$reportNull$$$0(0);
            }
            this.collectedVariables = collectedVariables;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression;
            if (referenceExpression == null) {
                AutoCloseableVariableUsedVisitor.$$$reportNull$$$0(1);
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiVariable variable = ExpressionUtils.resolveVariable((PsiExpression)referenceExpression);
            if (variable == null || !this.collectedVariables.contains(variable)) {
                return;
            }
            if (AutoCloseableVariableUsedVisitor.isInDifferentAnonymousClassOrLambda((PsiElement)referenceExpression, (PsiElement)variable)) {
                this.used = true;
                return;
            }
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, (boolean)true, (Class[])new Class[]{PsiMethodCallExpression.class, PsiExpressionList.class});
            if (parent instanceof PsiMethodCallExpression && !AutoCloseableVariableUsedVisitor.isCloseMethodCalled(methodCallExpression = (PsiMethodCallExpression)parent) || parent instanceof PsiExpressionList) {
                this.used = true;
            }
        }

        private static boolean isInDifferentAnonymousClassOrLambda(@NotNull PsiElement referenceExpression, @NotNull PsiElement variable) {
            if (referenceExpression == null) {
                AutoCloseableVariableUsedVisitor.$$$reportNull$$$0(2);
            }
            if (variable == null) {
                AutoCloseableVariableUsedVisitor.$$$reportNull$$$0(3);
            }
            return PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class, PsiLambdaExpression.class}) != PsiTreeUtil.getParentOfType((PsiElement)variable, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class, PsiLambdaExpression.class});
        }

        private static boolean isCloseMethodCalled(@NotNull PsiMethodCallExpression methodCallExpression) {
            PsiExpressionList argumentList;
            if (methodCallExpression == null) {
                AutoCloseableVariableUsedVisitor.$$$reportNull$$$0(4);
            }
            if (!(argumentList = methodCallExpression.getArgumentList()).isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collectedVariables";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$AutoCloseableVariableUsedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInDifferentAnonymousClassOrLambda";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCloseMethodCalled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableUsedWithContextVisitor
    extends VariableUsedVisitorBase {
        @NotNull
        private final PsiVariable variable;
        @Nullable
        private final PsiElement skipContext;

        VariableUsedWithContextVisitor(@NotNull PsiVariable variable, @Nullable PsiElement skipContext) {
            if (variable == null) {
                VariableUsedWithContextVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
            this.skipContext = skipContext;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableUsedWithContextVisitor.$$$reportNull$$$0(1);
            }
            if (this.used) {
                return;
            }
            if (element.equals((Object)this.skipContext)) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                VariableUsedWithContextVisitor.$$$reportNull$$$0(2);
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals((Object)this.variable)) {
                this.used = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedWithContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableUsedVisitorBase
    extends JavaRecursiveElementWalkingVisitor {
        protected boolean used;

        private VariableUsedVisitorBase() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableUsedVisitorBase.$$$reportNull$$$0(0);
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        public boolean isVariableUsed() {
            return this.used;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedVisitorBase", "visitElement"));
        }
    }

    private static class ResourceVariable {
        @Nullable(value="when in java 9")
        final @Nullable(value="when in java 9") PsiExpression myInitializer;
        final boolean myUsedOutsideTry;
        @NotNull
        final PsiVariable myVariable;

        ResourceVariable(@Nullable PsiExpression initializer, boolean usedOutsideTry, @NotNull PsiVariable variable) {
            if (variable == null) {
                ResourceVariable.$$$reportNull$$$0(0);
            }
            this.myInitializer = initializer;
            this.myUsedOutsideTry = usedOutsideTry;
            this.myVariable = variable;
        }

        String generateResourceDeclaration() {
            if (this.myUsedOutsideTry) {
                return this.myVariable.getName();
            }
            assert (this.myInitializer != null);
            return Objects.requireNonNull(this.myVariable.getTypeElement()).getText() + " " + this.myVariable.getName() + "=" + this.myInitializer.getText();
        }

        PsiElement getInitializedElement() {
            if (this.myInitializer != null) {
                return this.myInitializer;
            }
            return this.myVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$ResourceVariable", "<init>"));
        }
    }

    private static final class Context {
        @NotNull
        final List<ResourceVariable> myResourceVariables;
        @NotNull
        final List<PsiCatchSection> myCatchSectionsToAdd;
        @NotNull
        final Set<PsiStatement> myStatementsToDelete;

        private Context(@NotNull List<ResourceVariable> resourceVariables, @NotNull Set<PsiStatement> statementsToDelete, @NotNull List<PsiCatchSection> catchSectionsToAdd) {
            if (resourceVariables == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (statementsToDelete == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (catchSectionsToAdd == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.myResourceVariables = resourceVariables;
            this.myStatementsToDelete = statementsToDelete;
            this.myCatchSectionsToAdd = catchSectionsToAdd;
        }

        @Nullable
        static Context from(@NotNull PsiTryStatement tryStatement) {
            PsiVariable variable;
            PsiStatement statement;
            List<PsiStatement> statements;
            boolean varUsedNotInTry;
            PsiCodeBlock finallyBlock;
            if (tryStatement == null) {
                Context.$$$reportNull$$$0(3);
            }
            if ((finallyBlock = tryStatement.getFinallyBlock()) == null) {
                return null;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return null;
            }
            PsiStatement[] tryStatements = tryBlock.getStatements();
            PsiStatement[] finallyStatements = finallyBlock.getStatements();
            BitSet closedVariableStatementIndices = new BitSet(finallyStatements.length);
            HashSet<PsiVariable> collectedVariables = new HashSet<PsiVariable>();
            ArrayList<PsiCatchSection> catchSectionsToMigrate = new ArrayList<PsiCatchSection>();
            int length = finallyStatements.length;
            for (int i = 0; i < length; ++i) {
                boolean shouldDeleteStatement;
                PsiStatement statement2 = finallyStatements[i];
                if (statement2 instanceof PsiTryStatement) {
                    if (i != 0) {
                        return null;
                    }
                    shouldDeleteStatement = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement2, collectedVariables, catchSectionsToMigrate);
                } else {
                    shouldDeleteStatement = TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(statement2, collectedVariables);
                }
                closedVariableStatementIndices.set(i, shouldDeleteStatement);
            }
            if (collectedVariables.isEmpty()) {
                return null;
            }
            if (TryFinallyCanBeTryWithResourcesInspection.resourceVariableUsedInCatches(tryStatement, collectedVariables)) {
                return null;
            }
            if (TryFinallyCanBeTryWithResourcesInspection.resourceVariablesUsedInFinally(finallyBlock, collectedVariables)) {
                return null;
            }
            ArrayList<ResourceVariable> resourceVariables = new ArrayList<ResourceVariable>();
            ArrayList<PsiStatement> statementsToDelete = new ArrayList<PsiStatement>();
            IntArrayList initializerPositions = new IntArrayList();
            for (PsiVariable resourceVariable : collectedVariables) {
                boolean variableUsedOutsideTry = TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(resourceVariable, (PsiElement)tryStatement);
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.REFS_AS_RESOURCE, (PsiElement)finallyBlock) && variableUsedOutsideTry) {
                    return null;
                }
                if (!variableUsedOutsideTry && resourceVariable instanceof PsiLocalVariable) {
                    boolean hasNonNullInitializer;
                    PsiExpression initializer = resourceVariable.getInitializer();
                    boolean bl = hasNonNullInitializer = initializer != null && !PsiTypes.nullType().equals(initializer.getType());
                    if (!hasNonNullInitializer) {
                        int assignmentStatementIndex = TryFinallyCanBeTryWithResourcesInspection.findInitialization((PsiElement[])tryStatements, resourceVariable);
                        if (assignmentStatementIndex == -1) {
                            return null;
                        }
                        initializerPositions.add(assignmentStatementIndex);
                        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)tryStatements[assignmentStatementIndex];
                        PsiExpression expression = assignmentStatement.getExpression();
                        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expression, PsiAssignmentExpression.class);
                        if (assignment == null) {
                            return null;
                        }
                        initializer = assignment.getRExpression();
                        if (initializer == null) {
                            return null;
                        }
                        statementsToDelete.add(tryStatements[assignmentStatementIndex]);
                    } else if (VariableAccessUtils.variableIsAssigned(resourceVariable, (PsiElement)tryBlock)) {
                        return null;
                    }
                    resourceVariables.add(new ResourceVariable(initializer, false, resourceVariable));
                    continue;
                }
                if ((resourceVariable instanceof PsiLocalVariable && resourceVariable.getInitializer() != null || resourceVariable instanceof PsiParameter) && FinalUtils.canBeFinal(resourceVariable)) {
                    resourceVariables.add(new ResourceVariable(null, true, resourceVariable));
                    continue;
                }
                return null;
            }
            for (int i = 0; i < finallyStatements.length; ++i) {
                if (!closedVariableStatementIndices.get(i)) continue;
                statementsToDelete.add(finallyStatements[i]);
            }
            if (!Context.noStatementsBetweenVariableDeclarations(collectedVariables) || !Context.initializersAreAtTheBeginning((IntList)initializerPositions)) {
                return null;
            }
            resourceVariables.sort(Comparator.comparing(o -> o.getInitializedElement(), PsiElementOrderComparator.getInstance()));
            ResourceVariable lastNonTryVar = (ResourceVariable)ContainerUtil.findLast(resourceVariables, r -> !PsiTreeUtil.isAncestor((PsiElement)tryStatement, (PsiElement)r.myVariable, (boolean)false));
            if (lastNonTryVar != null && (varUsedNotInTry = StreamEx.of(statements = TryFinallyCanBeTryWithResourcesInspection.collectStatementsBetween(statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)(variable = lastNonTryVar.myVariable), PsiStatement.class), (PsiStatement)tryStatement)).flatMap(stmt -> StreamEx.ofTree((Object)stmt, e -> StreamEx.of((Object[])e.getChildren()))).select(PsiLocalVariable.class).anyMatch(variable1 -> TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext((PsiVariable)variable1, (PsiElement)tryStatement) || TryFinallyCanBeTryWithResourcesInspection.isVariableUsedInsideContext((PsiVariable)variable1, (PsiElement)finallyBlock)))) {
                return null;
            }
            return new Context(resourceVariables, new HashSet<PsiStatement>(statementsToDelete), catchSectionsToMigrate);
        }

        private static boolean initializersAreAtTheBeginning(IntList initializerPositions) {
            initializerPositions.sort(null);
            for (int i = 0; i < initializerPositions.size(); ++i) {
                if (initializerPositions.getInt(i) == i) continue;
                return false;
            }
            return true;
        }

        private static boolean noStatementsBetweenVariableDeclarations(Set<PsiVariable> collectedVariables) {
            return ((StreamEx)StreamEx.of(collectedVariables).select(PsiLocalVariable.class).sorted((Comparator)PsiElementOrderComparator.getInstance())).map(var -> (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)var, PsiStatement.class)).pairMap((l1, l2) -> l1 != null && l2 != null && l1.getParent() == l2.getParent() && TryFinallyCanBeTryWithResourcesInspection.collectStatementsBetween(l1, l2).isEmpty()).allMatch(b -> b);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceVariables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementsToDelete";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchSectionsToAdd";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$Context";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

