/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryUnboxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyUnboxed = false;
    @NonNls
    static final Map<String, String> s_unboxingMethods = Map.of("java.lang.Integer", "intValue", "java.lang.Short", "shortValue", "java.lang.Boolean", "booleanValue", "java.lang.Long", "longValue", "java.lang.Byte", "byteValue", "java.lang.Float", "floatValue", "java.lang.Double", "doubleValue", "java.lang.Character", "charValue");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryUnboxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyReportSuperfluouslyUnboxed", (String)InspectionGadgetsBundle.message("unnecessary.unboxing.superfluous.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryUnboxingInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryUnboxingFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            UnnecessaryUnboxingInspection.$$$reportNull$$$0(2);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnboxingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class UnnecessaryUnboxingFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryUnboxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unboxing.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryUnboxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiElement grandParent;
            if (project == null) {
                UnnecessaryUnboxingFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryUnboxingFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryUnboxingFix.$$$reportNull$$$0(3);
            }
            if (!((grandParent = element.getParent().getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
            if (strippedQualifier == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (strippedQualifier instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)strippedQualifier).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)target;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String classname = containingClass.getQualifiedName();
                if ("java.lang.Boolean".equals(classname)) {
                    @NonNls String name = field.getName();
                    if ("TRUE".equals(name)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "true", commentTracker);
                        return;
                    }
                    if ("FALSE".equals(name)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, "false", commentTracker);
                        return;
                    }
                }
            }
            String strippedQualifierText = commentTracker.text((PsiElement)strippedQualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, strippedQualifierText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessaryUnboxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnboxingVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!UnnecessaryUnboxingVisitor.isUnboxingExpression((PsiExpression)expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || this.isUnboxingNecessary((PsiExpression)expression, qualifier)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isUnboxingNecessary(@NotNull PsiExpression expression, @NotNull PsiExpression unboxedExpression) {
            PsiType expectedType;
            PsiPolyadicExpression polyadicExpression;
            if (expression == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(1);
            }
            if (unboxedExpression == null) {
                UnnecessaryUnboxingVisitor.$$$reportNull$$$0(2);
            }
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiPolyadicExpression && this.isPossibleObjectComparison(expression, polyadicExpression = (PsiPolyadicExpression)parent)) {
                return true;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement typeElement = typeCastExpression.getCastType();
                if (typeElement == null) {
                    return true;
                }
                PsiType castType = typeElement.getType();
                PsiType expressionType = expression.getType();
                if (expressionType == null || !castType.isAssignableFrom(expressionType)) {
                    return true;
                }
            } else if (parent instanceof PsiConditionalExpression) {
                PsiType type;
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                if (thenExpression == null) {
                    return true;
                }
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false) ? !((type = elseExpression.getType()) instanceof PsiPrimitiveType) : PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false) && !((type = thenExpression.getType()) instanceof PsiPrimitiveType)) {
                    return true;
                }
            } else if (MethodCallUtils.isNecessaryForSurroundingMethodCall(expression, unboxedExpression)) {
                return true;
            }
            if (!LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)expression, (PsiExpression)unboxedExpression)) {
                return true;
            }
            return UnnecessaryUnboxingInspection.this.onlyReportSuperfluouslyUnboxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiClassType);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType && !UnnecessaryUnboxingVisitor.isUnboxingExpression(operand)) continue;
                return true;
            }
            return false;
        }

        private static boolean isUnboxingExpression(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            String qualifierTypeName = qualifierType.getCanonicalText();
            if (!s_unboxingMethods.containsKey(qualifierTypeName)) {
                return false;
            }
            String methodName = methodExpression.getReferenceName();
            String unboxingMethod = s_unboxingMethods.get(qualifierTypeName);
            return unboxingMethod.equals(methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unboxedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnboxingNecessary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

