/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BigDecimalEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("big.decimal.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            BigDecimalEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new BigDecimalEqualsFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BigDecimalEqualsInspection", "buildErrorString"));
    }

    private static class BigDecimalEqualsFix
    extends PsiUpdateModCommandQuickFix {
        private BigDecimalEqualsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"compareTo()==0"});
            if (string == null) {
                BigDecimalEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            EqualityCheck check;
            if (project == null) {
                BigDecimalEqualsFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                BigDecimalEqualsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                BigDecimalEqualsFix.$$$reportNull$$$0(3);
            }
            if ((check = EqualityCheck.from((PsiExpression)(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class)))) == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression left = check.getLeft();
            PsiExpression right = check.getRight();
            String qualifierText = commentTracker.text(left, 1);
            String argText = commentTracker.text((PsiElement)right);
            @NonNls String replacement = qualifierText + ".compareTo(" + argText + ")==0";
            if (!check.isLeftDereferenced() && NullabilityUtil.getExpressionNullability(left, true) != Nullability.NOT_NULL) {
                boolean bothNullShouldEqual = call.getArgumentList().getExpressionCount() == 2 && NullabilityUtil.getExpressionNullability(right, true) != Nullability.NOT_NULL;
                replacement = bothNullShouldEqual ? left.getText() + "==null?" + right.getText() + "==null:" + replacement : left.getText() + "!=null && " + replacement;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)call, replacement, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/BigDecimalEqualsInspection$BigDecimalEqualsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/BigDecimalEqualsInspection$BigDecimalEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class BigDecimalEqualsVisitor
    extends BaseInspectionVisitor {
        private BigDecimalEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                BigDecimalEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            EqualityCheck check = EqualityCheck.from((PsiExpression)expression);
            if (check == null) {
                return;
            }
            PsiExpression left = check.getLeft();
            PsiExpression right = check.getRight();
            if (!ExpressionUtils.hasType(left, "java.math.BigDecimal")) {
                return;
            }
            if (!ExpressionUtils.hasType(right, "java.math.BigDecimal")) {
                return;
            }
            if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BigDecimalEqualsInspection$BigDecimalEqualsVisitor", "visitMethodCallExpression"));
        }
    }
}

