/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CachedNumberConstructorCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    static final Set<String> cachedNumberTypes = Set.of("java.lang.Long", "java.lang.Byte", "java.lang.Integer", "java.lang.Short");
    public boolean ignoreStringArguments = false;
    public boolean reportOnlyWhenDeprecated = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cached.number.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            CachedNumberConstructorCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreStringArguments", (String)InspectionGadgetsBundle.message("cached.number.constructor.call.ignore.string.arguments.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportOnlyWhenDeprecated", (String)InspectionGadgetsBundle.message("cached.number.constructor.call.report.only.deprecated", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CachedNumberConstructorCallInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            CachedNumberConstructorCallInspection.$$$reportNull$$$0(2);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LongConstructorVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiNewExpression expression = (PsiNewExpression)infos[0];
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        assert (classReference != null);
        String className = classReference.getText();
        return new CachedNumberConstructorCallFix(className);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class LongConstructorVisitor
    extends BaseInspectionVisitor {
        private LongConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            String qualifiedName;
            if (expression == null) {
                LongConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            String canonicalText = type.getCanonicalText();
            if (!cachedNumberTypes.contains(canonicalText)) {
                return;
            }
            PsiClass aClass = PsiUtil.getContainingClass((PsiElement)expression);
            if (aClass != null && (qualifiedName = aClass.getQualifiedName()) != null && cachedNumberTypes.contains(qualifiedName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null || CachedNumberConstructorCallInspection.this.ignoreStringArguments && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null || CachedNumberConstructorCallInspection.this.reportOnlyWhenDeprecated && !method.isDeprecated()) {
                return;
            }
            if (expression.getClassReference() == null) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$LongConstructorVisitor", "visitNewExpression"));
        }
    }

    private static class CachedNumberConstructorCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String className;

        CachedNumberConstructorCallFix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.className + ".valueOf()"});
            if (string == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{".valueOf()"});
            if (string == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CachedNumberConstructorCallFix.$$$reportNull$$$0(4);
            }
            PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiNewExpression.class, (boolean)false);
            assert (expression != null);
            PsiExpressionList argList = expression.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            PsiExpression arg = args[0];
            CommentTracker commentTracker = new CommentTracker();
            String text = commentTracker.text((PsiElement)arg);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, this.className + ".valueOf(" + text + ")", commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$CachedNumberConstructorCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$CachedNumberConstructorCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

