/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class CastedLiteralMaybeJustLiteralInspection
extends BaseInspection {
    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = this.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.problem.descriptor", replacementText);
        if (string == null) {
            CastedLiteralMaybeJustLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    abstract String getSuffix();

    @NotNull
    abstract PsiType getTypeBeforeCast();

    @NotNull
    abstract PsiPrimitiveType getCastType();

    private StringBuilder buildReplacementText(PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiLiteralExpression) {
            out.append(expression.getText()).append(this.getSuffix());
        } else {
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                out.append(prefixExpression.getOperationSign().getText());
                return this.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                out.append('(');
                this.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                this.buildReplacementText(typeCastExpression.getOperand(), out);
            } else assert (false);
        }
        return out;
    }

    @Override
    protected final LocalQuickFix buildFix(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = this.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return new ReplaceCastedLiteralWithJustLiteralFix(replacementText.toString());
    }

    @Override
    @NotNull
    public final BaseInspectionVisitor buildVisitor() {
        return new CastedLiteralMayBeJustLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection", "buildErrorString"));
    }

    private class ReplaceCastedLiteralWithJustLiteralFix
    extends PsiUpdateModCommandQuickFix {
        private final String replacementString;

        ReplaceCastedLiteralWithJustLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementString});
            if (string == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.casted.literal.with.just.literal.fix.family.name", CastedLiteralMaybeJustLiteralInspection.this.getCastType().getPresentableText());
            if (string == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceCastedLiteralWithJustLiteralFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection$ReplaceCastedLiteralWithJustLiteralFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection$ReplaceCastedLiteralWithJustLiteralFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class CastedLiteralMayBeJustLiteralVisitor
    extends BaseInspectionVisitor {
        private CastedLiteralMayBeJustLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                CastedLiteralMayBeJustLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!CastedLiteralMaybeJustLiteralInspection.this.getTypeBeforeCast().equals(type)) {
                return;
            }
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiPrefixExpression || parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (!CastedLiteralMaybeJustLiteralInspection.this.getCastType().equals((Object)castType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)typeCastExpression, false);
            if (expectedType == null) {
                return;
            }
            if (!CastedLiteralMaybeJustLiteralInspection.this.getCastType().equals((Object)expectedType)) {
                PsiClassType boxedType = CastedLiteralMaybeJustLiteralInspection.this.getCastType().getBoxedType((PsiElement)expression);
                assert (boxedType != null);
                if (!boxedType.equals((Object)expectedType)) {
                    return;
                }
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CastedLiteralMaybeJustLiteralInspection$CastedLiteralMayBeJustLiteralVisitor", "visitLiteralExpression"));
        }
    }
}

