/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfusingFloatingPointLiteralInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreScientificNotation = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreScientificNotation", (String)InspectionGadgetsBundle.message("confusing.floating.point.literal.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(2);
        }
        this.writeBooleanOption(node, "ignoreScientificNotation", false);
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ConfusingFloatingPointLiteralFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingFloatingPointLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ConfusingFloatingPointLiteralFix
    extends PsiUpdateModCommandQuickFix {
        private ConfusingFloatingPointLiteralFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.change.quickfix", new Object[0]);
            if (string == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(3);
            }
            PsiExpression literalExpression = (PsiExpression)startElement;
            String text = literalExpression.getText();
            String newText = ConfusingFloatingPointLiteralFix.getCanonicalForm(text);
            PsiReplacementUtil.replaceExpression(literalExpression, newText);
        }

        private static String getCanonicalForm(@NonNls String text) {
            String prefix;
            String suffix;
            boolean isHexadecimal = text.startsWith("0x") || text.startsWith("0X");
            int breakPoint = text.indexOf(101);
            if (breakPoint < 0) {
                breakPoint = text.indexOf(69);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(102);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(70);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(112);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(80);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(100);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(68);
            }
            if (breakPoint < 0) {
                suffix = "";
                prefix = text;
            } else {
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            }
            int indexPoint = prefix.indexOf(46);
            if (indexPoint < 0) {
                return prefix + ".0" + suffix;
            }
            if (isHexadecimal && indexPoint == 2) {
                return prefix.substring(0, 2) + "0" + prefix.substring(2) + suffix;
            }
            if (indexPoint == 0) {
                return "0" + prefix + suffix;
            }
            return prefix + "0" + suffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ConfusingFloatingPointLiteralVisitor
    extends BaseInspectionVisitor {
        private ConfusingFloatingPointLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                ConfusingFloatingPointLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(literal);
            PsiType type = literal.getType();
            String literalText = literal.getText();
            if (!PsiTypes.floatType().equals((Object)type) && !PsiTypes.doubleType().equals((Object)type) || !ConfusingFloatingPointLiteralVisitor.isConfusing(literalText)) {
                return;
            }
            if (ConfusingFloatingPointLiteralInspection.this.ignoreScientificNotation && StringUtil.containsAnyChar((String)literalText, (String)"EePp")) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }

        private static boolean isConfusing(@Nullable CharSequence text) {
            if (text == null) {
                return false;
            }
            int length = text.length();
            if (length < 3) {
                return true;
            }
            boolean hex = true;
            char firstChar = text.charAt(0);
            if (firstChar != '0') {
                if (!StringUtil.isDecimalDigit((char)firstChar)) {
                    return true;
                }
                hex = false;
            }
            char secondChar = text.charAt(1);
            if (hex && secondChar != 'x' && secondChar != 'X') {
                hex = false;
            }
            int index = hex ? 2 : 1;
            char nextChar = text.charAt(index);
            if (hex && !StringUtil.isHexDigit((char)nextChar)) {
                return true;
            }
            while (hex && StringUtil.isHexDigit((char)nextChar) || StringUtil.isDecimalDigit((char)nextChar) || nextChar == '_') {
                if (++index >= length) {
                    return true;
                }
                nextChar = text.charAt(index);
            }
            if (nextChar != '.') {
                return true;
            }
            if (++index >= length) {
                return true;
            }
            nextChar = text.charAt(index);
            return hex ? !StringUtil.isHexDigit((char)nextChar) : !StringUtil.isDecimalDigit((char)nextChar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralVisitor", "visitLiteralExpression"));
        }
    }
}

