/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DivideByZeroInspection
extends BaseInspection {
    public boolean reportMayBeZero = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportMayBeZero", (String)InspectionGadgetsBundle.message("divide.by.zero.problem.may.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(InspectionGadgetsBundle.message("divide.by.zero.problem.may.option.description", new Object[0]))});
        if (optPane == null) {
            DivideByZeroInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "divzero";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        ThreeState threeState;
        Object object;
        if (infos.length > 1 && (object = infos[1]) instanceof ThreeState && (threeState = (ThreeState)object) == ThreeState.UNSURE) {
            String string = InspectionGadgetsBundle.message("divide.by.zero.problem.may.descriptor", new Object[0]);
            if (string == null) {
                DivideByZeroInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("divide.by.zero.problem.descriptor", new Object[0]);
        if (string == null) {
            DivideByZeroInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        ThreeState threeState;
        PsiBinaryExpression binOp;
        Object object;
        if (infos.length > 0 && (object = infos[0]) instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)object).getOperationTokenType().equals(JavaTokenType.DIV) && this.isZero(binOp.getLOperand()) == ThreeState.YES) {
            PsiType type = binOp.getType();
            if (PsiTypes.doubleType().equals((Object)type) || PsiTypes.floatType().equals((Object)type)) {
                return new ReplaceWithNaNFix();
            }
        }
        if (infos.length > 1 && (object = infos[1]) instanceof ThreeState && (threeState = (ThreeState)object) == ThreeState.UNSURE) {
            return LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "reportMayBeZero", InspectionGadgetsBundle.message("divide.by.zero.problem.may.option.disabled", false), false));
        }
        return null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private ThreeState isZero(PsiExpression expression) {
        DfIntType dfIntType;
        LongRangeSet range;
        List ranges;
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiTypes.doubleType());
        if (value instanceof Double) {
            double constantValue = (Double)value;
            return constantValue == 0.0 ? ThreeState.YES : ThreeState.NO;
        }
        DfType dfType = CommonDataflow.getDfType(expression);
        Number val = (Number)dfType.getConstantOfType(Number.class);
        if (val != null) {
            return val.doubleValue() == 0.0 ? ThreeState.YES : ThreeState.NO;
        }
        if (!this.reportMayBeZero) {
            return ThreeState.NO;
        }
        if (dfType instanceof DfIntType && (ranges = (range = (dfIntType = (DfIntType)dfType).getRange()).asRanges()).size() < 4 && ContainerUtil.exists((Iterable)ranges, t -> t.getConstantValue() != null && t.getConstantValue() == 0L || t.max() - t.min() < 2L && t.contains(0L)) && !ContainerUtil.or((Iterable)ranges, t -> t.max() - t.min() > 21474836L || t.contains(Integer.MAX_VALUE) || t.contains(Integer.MIN_VALUE))) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/DivideByZeroInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceWithNaNFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithNaNFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiBinaryExpression division;
            if (project == null) {
                ReplaceWithNaNFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                ReplaceWithNaNFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ReplaceWithNaNFix.$$$reportNull$$$0(2);
            }
            if ((division = (PsiBinaryExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiBinaryExpression.class})) == null) {
                return;
            }
            PsiType type = division.getType();
            if (!(type instanceof PsiPrimitiveType)) {
                return;
            }
            String className = ((PsiPrimitiveType)type).getBoxedTypeName();
            new CommentTracker().replaceAndRestoreComments((PsiElement)division, className + ".NaN");
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"NaN"});
            if (string == null) {
                ReplaceWithNaNFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/DivideByZeroInspection$ReplaceWithNaNFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/DivideByZeroInspection$ReplaceWithNaNFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                DivisionByZeroVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.DIV.equals(tokenType) && !JavaTokenType.PERC.equals(tokenType)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                ThreeState zero = DivideByZeroInspection.this.isZero(operand);
                if (zero == ThreeState.NO) continue;
                this.registerError((PsiElement)operand, expression, zero);
                return;
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                DivisionByZeroVisitor.$$$reportNull$$$0(1);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = expression.getRExpression();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIVEQ) && !tokenType.equals(JavaTokenType.PERCEQ) || DivideByZeroInspection.this.isZero(rhs) != ThreeState.YES) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/numeric/DivideByZeroInspection$DivisionByZeroVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

