/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntegerDivisionInFloatingPointContextInspection
extends BaseInspection {
    @NonNls
    static final Set<String> s_integralTypes = Set.of("int", "long", "short", "byte", "char", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Character");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.problem.descriptor", new Object[0]);
        if (string == null) {
            IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        String castTo = (String)infos[0];
        return new IntegerDivisionInFloatingPointContextFix(castTo);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerDivisionInFloatingPointContextVisitor();
    }

    @NotNull
    private static PsiExpression getContainingExpression(@NotNull PsiExpression expression) {
        PsiElement parent;
        if (expression == null) {
            IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(1);
        }
        if ((parent = expression.getParent()) instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            PsiExpression psiExpression = !ComparisonUtils.isComparisonOperation(binaryExpression.getOperationTokenType()) ? IntegerDivisionInFloatingPointContextInspection.getContainingExpression((PsiExpression)binaryExpression) : expression;
            if (psiExpression == null) {
                IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(2);
            }
            return psiExpression;
        }
        if (parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
            return IntegerDivisionInFloatingPointContextInspection.getContainingExpression((PsiExpression)parent);
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(3);
        }
        return psiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class IntegerDivisionInFloatingPointContextFix
    extends PsiUpdateModCommandQuickFix {
        private final String myCastTo;

        private IntegerDivisionInFloatingPointContextFix(String castTo) {
            this.myCastTo = castTo;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                IntegerDivisionInFloatingPointContextFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                IntegerDivisionInFloatingPointContextFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                IntegerDivisionInFloatingPointContextFix.$$$reportNull$$$0(2);
            }
            if (!(startElement instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression expression = (PsiPolyadicExpression)startElement;
            PsiExpression[] operands = expression.getOperands();
            if (operands.length < 1) {
                return;
            }
            PsiExpression operand = operands[0];
            CommentTracker tracker = new CommentTracker();
            String text = tracker.text(operand, 4);
            tracker.replace((PsiElement)operand, "(" + this.myCastTo + ")" + text);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.fix.family.name", new Object[0]);
            if (string == null) {
                IntegerDivisionInFloatingPointContextFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.fix.name", this.myCastTo);
            if (string == null) {
                IntegerDivisionInFloatingPointContextFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection$IntegerDivisionInFloatingPointContextFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection$IntegerDivisionInFloatingPointContextFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class IntegerDivisionInFloatingPointContextVisitor
    extends BaseInspectionVisitor {
        IntegerDivisionInFloatingPointContextVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                IntegerDivisionInFloatingPointContextVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIV)) {
                return;
            }
            if (!IntegerDivisionInFloatingPointContextVisitor.hasIntegerDivision(expression)) {
                return;
            }
            PsiExpression context = IntegerDivisionInFloatingPointContextInspection.getContainingExpression((PsiExpression)expression);
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                contextType = context.getType();
            }
            if (!PsiTypes.floatType().equals((Object)contextType) && !PsiTypes.doubleType().equals((Object)contextType)) {
                return;
            }
            this.registerError((PsiElement)expression, contextType.getCanonicalText());
        }

        private static boolean hasIntegerDivision(@NotNull PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            if (expression == null) {
                IntegerDivisionInFloatingPointContextVisitor.$$$reportNull$$$0(1);
            }
            return (operands = expression.getOperands()).length >= 2 && IntegerDivisionInFloatingPointContextVisitor.isIntegral(operands[0].getType()) && IntegerDivisionInFloatingPointContextVisitor.isIntegral(operands[1].getType());
        }

        private static boolean isIntegral(PsiType type) {
            return type != null && s_integralTypes.contains(type.getCanonicalText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection$IntegerDivisionInFloatingPointContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasIntegerDivision";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

