/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public final class OctalLiteralInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "OctalInteger";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("octal.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            OctalLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
        if (localQuickFixArray == null) {
            OctalLiteralInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OctalLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/OctalLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OctalLiteralVisitor
    extends BaseInspectionVisitor {
        private OctalLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                OctalLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(literal);
            if (!ExpressionUtils.isOctalLiteral(literal)) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/siyeh/ig/numeric/OctalLiteralInspection$OctalLiteralVisitor", "visitLiteralExpression"));
        }
    }
}

