/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PointlessArithmeticExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final TokenSet arithmeticTokens = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC, JavaTokenType.GT, JavaTokenType.LT, JavaTokenType.LE, JavaTokenType.GE});
    public boolean m_ignoreExpressionsContainingConstants = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreExpressionsContainingConstants", (String)InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.calculateReplacementExpression((PsiPolyadicExpression)infos[0], null));
        if (string == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression, @Nullable CommentTracker ct) {
        PsiExpression[] operands = expression.getOperands();
        IElementType tokenType = expression.getOperationTokenType();
        PsiType type = expression.getType();
        List<PsiExpression> expressions = this.collectSalientOperands(operands, tokenType, type);
        PsiJavaToken token = expression.getTokenBeforeOperand(operands[1]);
        assert (token != null);
        String prefix = "";
        if (this.isZero(expressions.getFirst()) && expressions.size() > 1 && JavaTokenType.MINUS == token.getTokenType()) {
            expressions.removeFirst();
            prefix = "- ";
        }
        String delimiter = " " + token.getText() + " ";
        String result = prefix + expressions.stream().map(e -> ct == null ? e.getText() : ct.textWithComments((PsiElement)e)).collect(Collectors.joining(delimiter));
        boolean castToLongNeeded = ct != null && TypeConversionUtil.isLongType((PsiType)type) && !ContainerUtil.exists(expressions, x -> TypeConversionUtil.isLongType((PsiType)x.getType()));
        return castToLongNeeded ? "(long)" + result : result;
    }

    @NotNull
    List<PsiExpression> collectSalientOperands(PsiExpression[] operands, IElementType tokenType, PsiType type) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)operands[0].getProject());
        SmartList expressions = new SmartList();
        for (PsiExpression operand : operands) {
            if (tokenType.equals(JavaTokenType.PLUS) && this.isZero(operand) || tokenType.equals(JavaTokenType.MINUS) && this.isZero(operand) && !expressions.isEmpty() || tokenType.equals(JavaTokenType.ASTERISK) && this.isOne(operand) || tokenType.equals(JavaTokenType.DIV) && this.isOne(operand) && !expressions.isEmpty()) continue;
            if (tokenType.equals(JavaTokenType.MINUS) && !expressions.isEmpty() && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)expressions.getFirst(), operand)) {
                expressions.removeFirst();
                expressions.addFirst(factory.createExpressionFromText(PointlessArithmeticExpressionInspection.numberAsText(0, type), (PsiElement)operand));
                continue;
            }
            if (tokenType.equals(JavaTokenType.DIV) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions), operand)) {
                expressions.removeLast();
                expressions.addLast(factory.createExpressionFromText(PointlessArithmeticExpressionInspection.numberAsText(1, type), (PsiElement)operand));
                continue;
            }
            if (tokenType.equals(JavaTokenType.ASTERISK) && this.isZero(operand) || tokenType.equals(JavaTokenType.PERC) && (this.isOne(operand) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions), operand))) {
                expressions.clear();
                expressions.add(factory.createExpressionFromText(PointlessArithmeticExpressionInspection.numberAsText(0, type), (PsiElement)operand));
                SmartList smartList = expressions;
                if (smartList == null) {
                    PointlessArithmeticExpressionInspection.$$$reportNull$$$0(2);
                }
                return smartList;
            }
            expressions.add(operand);
        }
        if (expressions.isEmpty()) {
            int value = tokenType.equals(JavaTokenType.ASTERISK) ? 1 : 0;
            expressions.add(factory.createExpressionFromText(PointlessArithmeticExpressionInspection.numberAsText(value, type), (PsiElement)operands[0]));
        }
        SmartList smartList = expressions;
        if (smartList == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    @NonNls
    private static String numberAsText(int num, PsiType type) {
        if (PsiTypes.doubleType().equals((Object)type)) {
            String string = num + ".0";
            if (string == null) {
                PointlessArithmeticExpressionInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (PsiTypes.floatType().equals((Object)type)) {
            String string = num + ".0f";
            if (string == null) {
                PointlessArithmeticExpressionInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (PsiTypes.longType().equals((Object)type)) {
            String string = num + "L";
            if (string == null) {
                PointlessArithmeticExpressionInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = String.valueOf(num);
        if (string == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new PointlessArithmeticFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    boolean isZeroWithDataflow(@NotNull PsiExpression expression) {
        Number number;
        Object object;
        if (expression == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(8);
        }
        return this.isZero(expression) || (object = CommonDataflow.computeValue(expression)) instanceof Number && (number = (Number)object).doubleValue() == 0.0;
    }

    boolean isZero(@NotNull PsiExpression expression) {
        if (expression == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(9);
        }
        if (this.m_ignoreExpressionsContainingConstants && PointlessArithmeticExpressionInspection.containsReference(expression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    boolean isOne(@NotNull PsiExpression expression) {
        if (expression == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(10);
        }
        if (this.m_ignoreExpressionsContainingConstants && PointlessArithmeticExpressionInspection.containsReference(expression)) {
            return false;
        }
        return ExpressionUtils.isOne(expression);
    }

    private static boolean containsReference(@NotNull PsiExpression expression) {
        if (expression == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.findChildOfType((PsiElement)expression, PsiReferenceExpression.class, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSalientOperands";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "numberAsText";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isZeroWithDataflow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isZero";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOne";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private class PointlessArithmeticFix
    extends PsiUpdateModCommandQuickFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
            CommentTracker tracker = new CommentTracker();
            tracker.replaceExpressionAndRestoreComments((PsiExpression)expression, PointlessArithmeticExpressionInspection.this.calculateReplacementExpression(expression, tracker));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private PointlessArithmeticVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                PointlessArithmeticVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            if (!arithmeticTokens.contains(expression.getOperationTokenType())) {
                return;
            }
            if (ExpressionUtils.hasStringType((PsiExpression)expression) || PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            IElementType tokenType = expression.getOperationTokenType();
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            boolean isPointless = PsiTypes.doubleType().equals((Object)expressionType) || PsiTypes.floatType().equals((Object)expressionType) ? this.floatingPointOperationIsPointless(tokenType, operands) : (tokenType.equals(JavaTokenType.PLUS) ? this.additionExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.MINUS) ? this.subtractionExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.ASTERISK) ? this.multiplyExpressionIsPointless(operands) : (tokenType.equals(JavaTokenType.DIV) || tokenType.equals(JavaTokenType.PERC) ? this.divideExpressionIsPointless(operands) : false))));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean floatingPointOperationIsPointless(IElementType type, PsiExpression[] expressions) {
            if (expressions.length != 2) {
                return false;
            }
            if (type.equals(JavaTokenType.MINUS)) {
                return PointlessArithmeticVisitor.areExpressionsIdenticalWithoutSideEffects(expressions[0], expressions[1]);
            }
            if (type.equals(JavaTokenType.DIV) || type.equals(JavaTokenType.PERC)) {
                return PointlessArithmeticVisitor.areExpressionsIdenticalWithoutSideEffects(expressions[0], expressions[1]) && !PointlessArithmeticExpressionInspection.this.isZeroWithDataflow(expressions[0]) || type.equals(JavaTokenType.DIV) && PointlessArithmeticExpressionInspection.this.isOne(expressions[1]);
            }
            if (type.equals(JavaTokenType.ASTERISK)) {
                return (PointlessArithmeticExpressionInspection.this.isOne(expressions[0]) || PointlessArithmeticExpressionInspection.this.isOne(expressions[1])) && Objects.requireNonNull(expressions[0].getType()).equals(expressions[1].getType());
            }
            return false;
        }

        private boolean subtractionExpressionIsPointless(PsiExpression[] expressions) {
            PsiExpression firstExpression = expressions[0];
            if (PointlessArithmeticExpressionInspection.this.isZero(firstExpression)) {
                return true;
            }
            for (int i = 1; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression) && !PointlessArithmeticVisitor.areExpressionsIdenticalWithoutSideEffects(firstExpression, expression)) continue;
                return true;
            }
            return false;
        }

        private boolean additionExpressionIsPointless(PsiExpression[] expressions) {
            for (PsiExpression expression : expressions) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression)) continue;
                return true;
            }
            return false;
        }

        private boolean multiplyExpressionIsPointless(PsiExpression[] expressions) {
            for (PsiExpression expression : expressions) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression) && !PointlessArithmeticExpressionInspection.this.isOne(expression)) continue;
                return true;
            }
            return false;
        }

        private boolean divideExpressionIsPointless(PsiExpression[] expressions) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isOne(expression) || i == 1 && PointlessArithmeticVisitor.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression) && !PointlessArithmeticExpressionInspection.this.isZeroWithDataflow(expression))) {
                    return true;
                }
                previousExpression = expression;
            }
            return false;
        }

        private static boolean areExpressionsIdenticalWithoutSideEffects(PsiExpression expression1, PsiExpression expression2) {
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expression1, expression2) && !SideEffectChecker.mayHaveSideEffects(expression1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticVisitor", "visitPolyadicExpression"));
        }
    }
}

