/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.LiteralFormatUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnpredictableBigDecimalConstructorCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreReferences = true;
    public boolean ignoreComplexLiterals = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnpredictableBigDecimalConstructorCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreReferences", (String)InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.references.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreComplexLiterals", (String)InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.complex.literals.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnpredictableBigDecimalConstructorCallInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiNewExpression newExpression = (PsiNewExpression)infos[0];
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return null;
        }
        PsiExpression firstArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
        if (firstArgument instanceof PsiLiteralExpression) {
            PsiLiteralExpression expression = (PsiLiteralExpression)firstArgument;
            return new ReplaceDoubleArgumentWithStringFix("new BigDecimal(\"" + UnpredictableBigDecimalConstructorCallInspection.getLiteralText(expression) + "\")");
        }
        if (arguments.length == 1 && firstArgument != null) {
            return new ReplaceDoubleArgumentWithStringFix("BigDecimal.valueOf(" + firstArgument.getText() + ")");
        }
        return null;
    }

    static String getLiteralText(PsiLiteralExpression firstArgument) {
        String text = LiteralFormatUtil.removeUnderscores((String)firstArgument.getText());
        char c = text.charAt(text.length() - 1);
        return c == 'd' || c == 'D' || c == 'f' || c == 'F' ? text.substring(0, text.length() - 1) : text;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnpredictableBigDecimalConstructorCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceDoubleArgumentWithStringFix
    extends PsiUpdateModCommandQuickFix {
        private final String argumentText;

        ReplaceDoubleArgumentWithStringFix(@NonNls String argumentText) {
            this.argumentText = argumentText;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.argumentText});
            if (string == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"BigDecimal.valueOf()"});
            if (string == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiNewExpression newExpression;
            if (project == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(4);
            }
            if (!ReplaceDoubleArgumentWithStringFix.isStillValid(newExpression = (PsiNewExpression)element.getParent())) {
                return;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            if (firstArgument instanceof PsiLiteralExpression) {
                PsiLiteralExpression expression = (PsiLiteralExpression)firstArgument;
                PsiReplacementUtil.replaceExpression(firstArgument, "\"" + UnpredictableBigDecimalConstructorCallInspection.getLiteralText(expression) + "\"");
            } else if (arguments.length == 1 && firstArgument != null) {
                PsiReplacementUtil.replaceExpression((PsiExpression)newExpression, "java.math.BigDecimal.valueOf(" + firstArgument.getText() + ")");
            }
        }

        private static boolean isStillValid(PsiNewExpression newExpression) {
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiParameter[] parameters = constructor.getParameterList().getParameters();
            return parameters.length != 0 && PsiTypes.doubleType().equals((Object)parameters[0].getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection$ReplaceDoubleArgumentWithStringFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection$ReplaceDoubleArgumentWithStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnpredictableBigDecimalConstructorCallVisitor
    extends BaseInspectionVisitor {
        private UnpredictableBigDecimalConstructorCallVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                UnpredictableBigDecimalConstructorCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            if (!ConstructionUtils.isReferenceTo(classReference, "java.math.BigDecimal")) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int length = parameterList.getParametersCount();
            if (length != 1 && length != 2) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter firstParameter = parameters[0];
            PsiType type = firstParameter.getType();
            if (!PsiTypes.doubleType().equals((Object)type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            if (!this.checkExpression(firstArgument)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private boolean checkExpression(@Nullable PsiExpression expression) {
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
                return false;
            }
            if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreReferences && PsiTreeUtil.findChildOfType((PsiElement)expression, PsiReferenceExpression.class, (boolean)false) != null) {
                return false;
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreComplexLiterals) {
                    return false;
                }
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (this.checkExpression(operand)) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection$UnpredictableBigDecimalConstructorCallVisitor", "visitNewExpression"));
        }
    }
}

