/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CanBeStaticVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean canBeStatic = true;

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            CanBeStaticVisitor.$$$reportNull$$$0(0);
        }
        if (this.canBeStatic) {
            super.visitElement(element);
        }
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            CanBeStaticVisitor.$$$reportNull$$$0(1);
        }
        this.canBeStatic = false;
        this.stopWalking();
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        PsiClass cls;
        PsiElement psiElement;
        if (expression == null) {
            CanBeStaticVisitor.$$$reportNull$$$0(2);
        }
        super.visitNewExpression(expression);
        PsiJavaCodeReferenceElement classRef = expression.getClassReference();
        if (expression.getQualifier() == null && classRef != null && (psiElement = classRef.resolve()) instanceof PsiClass && !(cls = (PsiClass)psiElement).hasModifierProperty("static") && !ClassUtil.isTopLevelClass((PsiClass)cls)) {
            this.canBeStatic = false;
            this.stopWalking();
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        PsiClass cls;
        PsiModifierListOwner owner;
        if (ref == null) {
            CanBeStaticVisitor.$$$reportNull$$$0(3);
        }
        super.visitReferenceExpression(ref);
        PsiElement element = ref.resolve();
        if (!(!(element instanceof PsiModifierListOwner) || (owner = (PsiModifierListOwner)element).hasModifierProperty("static") || owner instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)(cls = (PsiClass)owner)))) {
            this.canBeStatic = false;
            this.stopWalking();
        }
    }

    public boolean canBeStatic() {
        return this.canBeStatic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/performance/CanBeStaticVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

