/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LengthOneStringInIndexOfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression literal = (PsiExpression)infos[0];
        String replacement = LengthOneStringInIndexOfInspection.getReplacement(literal);
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.no.quotes.problem.descriptor", literal.getText(), replacement);
        if (string == null) {
            LengthOneStringInIndexOfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInIndexOfVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    @NotNull
    private static String getReplacement(PsiExpression expression) {
        String character;
        String text = expression.getText();
        int length = text.length();
        Object object = switch (character = text.substring(1, length - 1)) {
            case "'" -> "'\\''";
            case "\\\"" -> "'\"'";
            default -> "'" + character + "'";
        };
        if (object == null) {
            LengthOneStringInIndexOfInspection.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LengthOneStringsInIndexOfVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInIndexOfVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                LengthOneStringsInIndexOfVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            String value = (String)expression.getValue();
            if (value == null || value.length() != 1) {
                return;
            }
            if (!LengthOneStringsInIndexOfVisitor.isArgumentOfIndexOf((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        static boolean isArgumentOfIndexOf(PsiExpression expression) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandparent = parent.getParent();
            if (!(grandparent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            @NonNls String name = methodExpression.getReferenceName();
            if (!"indexOf".equals(name) && !"lastIndexOf".equals(name)) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            String className = methodClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection$LengthOneStringsInIndexOfVisitor", "visitLiteralExpression"));
        }
    }

    private static class ReplaceStringsWithCharsFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceStringsWithCharsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(3);
            }
            PsiExpression expression = (PsiExpression)startElement;
            String charLiteral = LengthOneStringInIndexOfInspection.getReplacement(expression);
            PsiReplacementUtil.replaceExpression(expression, charLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection$ReplaceStringsWithCharsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/LengthOneStringInIndexOfInspection$ReplaceStringsWithCharsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

